/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.basinheater;

import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.basinheater.BasinHeaterBlock;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class BasinHeaterBlockEntity
extends ElectricBlockEntity {
    private ElectricWire coil;
    private BlazeBurnerBlock.HeatLevel state;

    public BasinHeaterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = (BlazeBurnerBlock.HeatLevel)state.m_61143_(BasinHeaterBlock.HEAT_LEVEL);
    }

    public void setState(BlazeBurnerBlock.HeatLevel newState) {
        assert (this.f_58857_ != null);
        if (this.state != newState) {
            this.state = newState;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(BasinHeaterBlock.HEAT_LEVEL, (Comparable)this.state));
        }
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        Double I = (Double)ModdedConfigs.server().electricity.basinHeaterCurrent.get();
        double power = I * I * (double)this.resistance("idle");
        float factor = (float)(power / 578.0);
        return ThermalBehaviour.always(this, 2.0f, factor, 1400.0f);
    }

    public boolean mixerRunning() {
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_6630_(3));
        if (!(be instanceof MechanicalMixerBlockEntity)) {
            return false;
        }
        MechanicalMixerBlockEntity mixer = (MechanicalMixerBlockEntity)be;
        return mixer.running;
    }

    public void tick() {
        this.applyPower(this.coil);
        super.tick();
        if (this.thermalBehaviour == null) {
            PowerGrid.LOGGER.warn("Basin heater should always have a thermal behaviour");
            return;
        }
        this.coil.setResistance(this.mixerRunning() ? (double)this.resistance("mixing") : (double)this.resistance("idle"));
        float T = this.thermalBehaviour.getTemperature();
        float dissipation = 0.005625f * T - 1.625f;
        if (this.mixerRunning()) {
            double I = (Double)ModdedConfigs.server().electricity.basinHeaterCurrent.get() * 2.0;
            double power = I * I * (double)(this.resistance("idle") - this.resistance("mixing"));
            dissipation += (float)(power / 978.0);
        }
        this.thermalBehaviour.setDissipationFactor(dissipation);
        if (T < 600.0f) {
            this.setState(BlazeBurnerBlock.HeatLevel.NONE);
        } else if (T < 1000.0f) {
            this.setState(BlazeBurnerBlock.HeatLevel.KINDLED);
        } else {
            this.setState(BlazeBurnerBlock.HeatLevel.SEETHING);
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.coil = builder.connect(this.resistance("idle"), builder.terminalNode(0), builder.terminalNode(1));
    }
}

