/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.HorizontalElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.battery.AbstractBatteryBlock;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;
import org.patryk3211.powergrid.electricity.battery.PotatoBatteryBlockEntity;
import org.patryk3211.powergrid.electricity.battery.SimpleBatterySpec;

public class PotatoBatteryBlock
extends AbstractBatteryBlock<PotatoBatteryBlockEntity> {
    public static final BatterySpec BATTERY_SPEC = new SimpleBatterySpec(0.216f, 0.216f, e -> Float.valueOf(0.4f * e.floatValue() + 0.5f), e -> Float.valueOf((float)Math.exp(-6.15619f * e.floatValue() + 9.28731f) + 430.0f));
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty BAKED = BooleanProperty.m_61465_((String)"baked");
    private static final TerminalBoundingBox[] TERMINALS_NORTH = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.POSITIVE, 7.0, 3.0, 4.5, 9.0, 5.5, 6.0).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.NEGATIVE, 7.0, 3.0, 10.0, 9.0, 5.5, 11.5).withColor(3899647)};
    private static final VoxelShape SHAPE_NORTH = PotatoBatteryBlock.m_49796_((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)3.0, (double)11.0);

    public PotatoBatteryBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BAKED, (Comparable)Boolean.valueOf(false)));
        this.setTerminalCollection(HorizontalElectricBlock.horizontalNorthTerminals(this, TERMINALS_NORTH, SHAPE_NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, BAKED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction player = ctx.m_43723_() == null || !ctx.m_43723_().m_6144_() ? ctx.m_8125_() : ctx.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)player.m_122427_());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return PotatoBatteryBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !this.m_7898_(state, (LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public BatterySpec getSpec() {
        return BATTERY_SPEC;
    }

    public Class<PotatoBatteryBlockEntity> getBlockEntityClass() {
        return PotatoBatteryBlockEntity.class;
    }

    public BlockEntityType<? extends PotatoBatteryBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.POTATO_BATTERY.get();
    }
}

