/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.contactor;

import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.config.ThermalValues;
import org.patryk3211.powergrid.electricity.base.HorizontalAxisElectricBlock;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.contactor.ContactorBlockEntity;
import org.patryk3211.powergrid.electricity.deviceconnector.IAcceptConnector;
import org.patryk3211.powergrid.electricity.info.Current;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.utility.Lang;

public class ContactorBlock
extends HorizontalAxisElectricBlock
implements IBE<ContactorBlockEntity>,
IHaveElectricProperties,
IAcceptConnector {
    public static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)ContactorBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ContactorBlock.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)14.0, (double)12.0), ContactorBlock.m_49796_((double)6.0, (double)12.0, (double)0.0, (double)10.0, (double)13.0, (double)4.0), ContactorBlock.m_49796_((double)6.0, (double)12.0, (double)12.0, (double)10.0, (double)13.0, (double)16.0)});
    public static final Component SWITCH1 = Lang.builder().translate("contactor.switch1", new Object[0]).style(ChatFormatting.GRAY).component();
    public static final Component SWITCH2 = Lang.builder().translate("contactor.switch2", new Object[0]).style(ChatFormatting.GRAY).component();
    public static final TerminalBoundingBox[] TERMINALS_NORTH = new TerminalBoundingBox[]{null, null, new TerminalBoundingBox(SWITCH1, 2.0, 10.0, 0.0, 6.0, 12.0, 4.0), new TerminalBoundingBox(SWITCH1, 2.0, 10.0, 12.0, 6.0, 12.0, 16.0), new TerminalBoundingBox(SWITCH2, 10.0, 10.0, 0.0, 14.0, 12.0, 4.0), new TerminalBoundingBox(SWITCH2, 10.0, 10.0, 12.0, 14.0, 12.0, 16.0)};

    public ContactorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.setTerminalCollection(ContactorBlock.horizontalZTerminals(this, TERMINALS_NORTH, SHAPE_NORTH));
    }

    @Override
    public boolean accepts(ItemStack wireStack) {
        return true;
    }

    public Class<ContactorBlockEntity> getBlockEntityClass() {
        return ContactorBlockEntity.class;
    }

    public BlockEntityType<? extends ContactorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.CONTACTOR.get();
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Resistance.coil(this.resistance("coil"), player, tooltip);
        Voltage.rated(24.0f, player, tooltip);
        Resistance.switchResistance(this.resistance("switch"), player, tooltip);
        Current.max(this.resistance("switch"), ThermalValues.getPower(this) - 48.0f, player, tooltip);
    }

    @Override
    public boolean canConnect(LevelReader world, BlockPos pos, BlockState state, Direction side) {
        return side.m_122434_() != Direction.Axis.Y && state.m_61143_((Property)HORIZONTAL_AXIS) != side.m_122434_();
    }
}

