/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.gauge;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.gauge.GaugeBlockEntity;
import org.patryk3211.powergrid.utility.Lang;

public class ElectricGaugeDisplaySource
extends PercentOrProgressBarDisplaySource {
    @Nullable
    protected Float getProgress(DisplayLinkContext context) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (blockEntity instanceof GaugeBlockEntity) {
            GaugeBlockEntity gauge = (GaugeBlockEntity)blockEntity;
            return Float.valueOf(gauge.getProgress());
        }
        return Float.valueOf(0.0f);
    }

    protected MutableComponent formatNumeric(DisplayLinkContext context, Float currentLevel) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (blockEntity instanceof GaugeBlockEntity) {
            GaugeBlockEntity gauge = (GaugeBlockEntity)blockEntity;
            float value = gauge.getValue();
            if (this.getMode(context) == 1) {
                value = Math.abs(value);
            }
            return Lang.numberConstant(value).add(Component.m_237113_((String)" ")).add(gauge.getUnit().get()).component();
        }
        return super.formatNumeric(context, currentLevel);
    }

    private int getMode(DisplayLinkContext context) {
        return context.sourceConfig().m_128451_("Mode");
    }

    protected boolean progressBarActive(DisplayLinkContext context) {
        return this.getMode(context) == 0;
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

    protected String getTranslationKey() {
        return "electric_gauge";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.electric_gauge", "progress_bar", "absolute", "polarized")).titled(Lang.translateDirect("display_source.display_information", new Object[0])), "Mode");
    }
}

