/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.grounding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedDamageTypes;
import org.patryk3211.powergrid.collections.ModdedTags;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class GroundingRodBlockEntity
extends ElectricBlockEntity {
    private static final float DANGER_POTENTIAL = 48.0f;
    private SwitchedWire wire;
    private int groundCount;
    private int conductiveCount;
    private int damageTickCounter;

    public GroundingRodBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    private static int minBlocks() {
        return (Integer)ModdedConfigs.server().electricity.groundingMinimumBlocks.get();
    }

    private void scan(BlockPos pos) {
        assert (this.f_58857_ != null);
        HashSet<BlockPos> scanned = new HashSet<BlockPos>();
        ArrayList<BlockPos> queue = new ArrayList<BlockPos>();
        queue.add(pos);
        while (!queue.isEmpty()) {
            BlockPos checkPos = (BlockPos)queue.remove(0);
            if (!scanned.add(checkPos)) continue;
            for (Direction dir : Direction.values()) {
                BlockPos nextPos = checkPos.m_121945_(dir);
                if (scanned.contains(nextPos)) continue;
                BlockState state = this.f_58857_.m_8055_(nextPos);
                if (state.m_204336_(ModdedTags.Block.CONDUCTIVE_GROUND.tag)) {
                    ++this.conductiveCount;
                } else if (this.groundCount >= GroundingRodBlockEntity.minBlocks() || state.m_60796_((BlockGetter)this.f_58857_, nextPos) && ++this.groundCount >= GroundingRodBlockEntity.minBlocks()) continue;
                if (nextPos.m_123333_((Vec3i)pos) >= 10) continue;
                queue.add(nextPos);
            }
            if (this.conductiveCount < (Integer)ModdedConfigs.server().electricity.groundingMaximumBlocks.get() || this.groundCount < GroundingRodBlockEntity.minBlocks()) continue;
            break;
        }
    }

    public void lazyTick() {
        assert (this.f_58857_ != null);
        super.lazyTick();
        if (!this.f_58857_.f_46443_) {
            int prevConductiveCount = this.conductiveCount;
            this.groundCount = 1;
            this.conductiveCount = 0;
            this.scan(this.m_58899_().m_7495_());
            boolean prevState = this.wire.getState();
            if (this.groundCount < GroundingRodBlockEntity.minBlocks()) {
                this.wire.setState(false);
            } else {
                float highR = ModdedConfigs.server().electricity.groundingHighestResistance.getF();
                float lowR = ModdedConfigs.server().electricity.groundingLowestResistance.getF();
                int maxBlocks = (Integer)ModdedConfigs.server().electricity.groundingMaximumBlocks.get();
                float delta = (highR - lowR) / (float)maxBlocks;
                float resistance = highR - delta * (float)this.conductiveCount / (float)maxBlocks;
                this.wire.setResistance(resistance);
                this.wire.setState(true);
            }
            if (prevState != this.wire.getState() || prevConductiveCount != this.conductiveCount) {
                this.notifyUpdate();
            }
        }
    }

    public void tick() {
        assert (this.f_58857_ != null);
        super.tick();
        if (!this.f_58857_.f_46443_ && this.damageTickCounter++ >= 10) {
            this.damageTickCounter = 0;
            double dangerRadius = Math.min(Math.abs(this.wire.getResistance() * (double)this.wire.current() / 301.59289474462014), 10.0);
            int blockRadius = (int)Math.round(dangerRadius);
            AABB bb = new AABB(this.f_58858_.m_7918_(-blockRadius, -blockRadius, -blockRadius), this.f_58858_.m_7918_(blockRadius, blockRadius, blockRadius));
            double sqrDist = dangerRadius * dangerRadius;
            Vec3 center = this.f_58858_.m_252807_();
            List entities = this.f_58857_.m_6443_(LivingEntity.class, bb, e -> e.m_20182_().m_82557_(center) <= sqrDist && e.m_20096_());
            Registry registry = this.f_58857_.m_9598_().m_175515_(Registries.f_268580_);
            DamageSource source = new DamageSource((Holder)registry.m_203636_(ModdedDamageTypes.ZAP).get());
            for (LivingEntity entity : entities) {
                entity.m_6469_(source, 1.0f);
            }
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(1);
        this.wire = builder.connectSwitch(1.0f, builder.terminalNode(0), null, false);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("Resistance")) {
            this.wire.setResistance(tag.m_128457_("Resistance"));
            this.wire.setState(true);
        } else {
            this.wire.setState(false);
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.wire.getState()) {
            tag.m_128350_("Resistance", (float)this.wire.getResistance());
        }
    }
}

