/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.PerformanceCounter;
import org.patryk3211.powergrid.electricity.sim.node.CurrentSourceNode;
import org.patryk3211.powergrid.electricity.sim.node.ElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.ICouplingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;
import org.patryk3211.powergrid.electricity.sim.solver.DirectSolver;
import org.patryk3211.powergrid.electricity.sim.solver.DynamicallyTypedMatrix;
import org.patryk3211.powergrid.electricity.sim.solver.IOuterHook;
import org.patryk3211.powergrid.electricity.sim.solver.ISolver;
import org.patryk3211.powergrid.electricity.sim.solver.ISolverHook;
import org.patryk3211.powergrid.electricity.sim.solver.IStaticResidual;
import org.patryk3211.powergrid.electricity.sim.special.CapacitorWire;
import org.slf4j.Logger;

public class ElectricalNetwork {
    public static final double G_MIN = 1.0E-8;
    private static final double PRECISION = 1.0E-7;
    private static final PerformanceCounter PERF = new PerformanceCounter("NetSolve");
    private static final int MAX_SCALE_REUSE_COUNT = 20;
    private final boolean addGMin;
    protected final Set<AbstractElectricWire> wires = new HashSet<AbstractElectricWire>();
    protected final Set<ICouplingNode> couplings = new HashSet<ICouplingNode>();
    protected final List<INode> nodes = new ArrayList<INode>();
    private int eliminatedStart;
    private final Set<IOuterHook> outerHooks = new HashSet<IOuterHook>();
    private final Set<ISolverHook> innerHooks = new HashSet<ISolverHook>();
    private final Set<ISolverHook> leafInnerHooks = new HashSet<ISolverHook>();
    private final Set<IStaticResidual> residuals = new HashSet<IStaticResidual>();
    protected final Map<IElectricNode, IElectricNode> leafNodes = new HashMap<IElectricNode, IElectricNode>();
    private final ISolver solver;
    private int sourceCount = 0;
    private int groundReferenceCount;
    private DMatrixRMaj ResidualVector;
    private DynamicallyTypedMatrix JacobianKept;
    private DynamicallyTypedMatrix JacobianEliminated;
    private DynamicallyTypedMatrix JacobianRight;
    private DynamicallyTypedMatrix JacobianBottom;
    private DMatrixRMaj ReducedRHSVector;
    private DMatrixRMaj EliminatedRHSVector;
    private DynamicallyTypedMatrix WMatrix;
    private DynamicallyTypedMatrix ReducedCorrection;
    private DynamicallyTypedMatrix ReducedJacobian;
    private DynamicallyTypedMatrix ScaledJ;
    private DMatrixRMaj StateVector;
    private DMatrixRMaj AuxiliaryVector;
    private DMatrixRMaj EliminatedSolved;
    private double[] columnScales;
    private double[] rowScales;
    private boolean dirty = true;
    private double conductanceDelta = 0.0;
    private int conductanceUpdates = 0;
    private int eliminatedUpdates = 0;
    private int scalesAge = 0;
    private boolean countUpdates = true;
    private boolean lockEliminated = false;
    private boolean converged;
    private int warmUpTicks = 0;
    private boolean recalculateScales;
    private boolean eliminatedChanged;
    private boolean eliminatedRHSZero;
    private boolean eliminatedSolved;
    public static Logger LOGGER = null;
    public Function<Boolean, Integer> maxIterations = b -> 200;

    public ElectricalNetwork(boolean addGMin) {
        this.solver = new DirectSolver();
        this.addGMin = addGMin;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean hasHooks() {
        return !this.innerHooks.isEmpty();
    }

    public void warmUp(int ticks) {
        if (ticks == -1 || this.warmUpTicks == -1) {
            this.warmUpTicks = -1;
            return;
        }
        if (this.warmUpTicks < ticks) {
            this.warmUpTicks = ticks;
        }
    }

    public void addNode(INode node) {
        if (this.nodes.contains(node) || this.leafNodes.containsKey(node)) {
            return;
        }
        node.assignIndex(this.eliminatedStart);
        node.setNetwork(this);
        for (int i = this.eliminatedStart; i < this.nodes.size(); ++i) {
            this.nodes.get(i).assignIndex(i + 1);
        }
        this.nodes.add(this.eliminatedStart++, node);
        this.setDirty();
        if (node instanceof IOuterHook) {
            IOuterHook hook = (IOuterHook)((Object)node);
            this.outerHooks.add(hook);
        }
        if (node instanceof ISolverHook) {
            ISolverHook hook = (ISolverHook)((Object)node);
            this.innerHooks.add(hook);
        }
        if (node instanceof IStaticResidual) {
            IStaticResidual residual = (IStaticResidual)((Object)node);
            this.residuals.add(residual);
        }
        if (node instanceof IElectricNode) {
            IElectricNode enode = (IElectricNode)node;
            this.addNode(enode);
        }
        if (node instanceof ICouplingNode) {
            ICouplingNode cnode = (ICouplingNode)node;
            this.addNode(cnode);
        }
        this.warmUp(5);
    }

    private void addNode(IElectricNode node) {
        if (node instanceof CurrentSourceNode) {
            ++this.sourceCount;
        }
    }

    private void addNode(ICouplingNode coupling) {
        this.couplings.add(coupling);
        if (coupling instanceof VoltageSourceCoupling) {
            ++this.sourceCount;
        }
    }

    public void addNodes(INode ... nodes) {
        for (INode node : nodes) {
            this.addNode(node);
        }
    }

    public void removeNode(INode node) {
        this.internalRemoveNode(node);
    }

    protected final void internalRemoveNode(INode node) {
        if (node == null) {
            return;
        }
        if (this.leafNodes.containsKey(node)) {
            node.setNetwork(null);
            this.leafNodes.remove(node);
            return;
        }
        if (node.getNetwork() != this || node.getIndex() >= this.nodes.size() || this.nodes.get(node.getIndex()) != node) {
            return;
        }
        for (int i = node.getIndex() + 1; i < this.nodes.size(); ++i) {
            this.nodes.get(i).assignIndex(i - 1);
            if (this.StateVector == null || i >= this.StateVector.getNumRows()) continue;
            this.StateVector.set(i - 1, 0, this.StateVector.get(i, 0));
        }
        this.nodes.remove(node.getIndex());
        if (node.getIndex() < this.eliminatedStart) {
            --this.eliminatedStart;
        }
        if (node instanceof ICouplingNode) {
            this.couplings.remove(node);
        }
        if (node instanceof CurrentSourceNode || node instanceof VoltageSourceCoupling) {
            --this.sourceCount;
        }
        if (node instanceof IOuterHook) {
            IOuterHook hook = (IOuterHook)((Object)node);
            this.outerHooks.remove(hook);
        }
        if (node instanceof ISolverHook) {
            ISolverHook hook = (ISolverHook)((Object)node);
            this.innerHooks.remove(hook);
        }
        if (node instanceof IStaticResidual) {
            IStaticResidual residual = (IStaticResidual)((Object)node);
            this.residuals.remove(residual);
        }
        this.warmUp(3);
        node.setNetwork(null);
        this.setDirty();
    }

    public void removeNode(int index) {
        if (this.nodes.size() <= index) {
            return;
        }
        this.removeNode(this.nodes.get(index));
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty() && this.leafNodes.isEmpty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isConverged() {
        return this.converged;
    }

    public void addWire(AbstractElectricWire wire) {
        Object hook;
        if (wire.node1 != null && !this.nodes.contains(wire.node1) && !this.leafNodes.containsKey(wire.node1)) {
            String suffix = wire.node1.getNetwork() == null ? "no network" : "different network";
            throw new IllegalArgumentException("Both nodes of a wire must be part of the network (node1 " + String.valueOf(wire.node1) + " isn't - " + suffix + ")");
        }
        if (wire.node2 != null && !this.nodes.contains(wire.node2) && !this.leafNodes.containsKey(wire.node2)) {
            String suffix = wire.node2.getNetwork() == null ? "no network" : "different network";
            throw new IllegalArgumentException("Both nodes of a wire must be part of the network (node2 " + String.valueOf(wire.node2) + " isn't - " + suffix + ")");
        }
        wire.setNetwork(this);
        this.wires.add(wire);
        if (wire instanceof CapacitorWire) {
            ++this.sourceCount;
        }
        if (wire.node1 == null || wire.node2 == null) {
            ++this.groundReferenceCount;
        }
        this.updateConductance(wire, wire.conductance());
        if (wire instanceof IOuterHook) {
            hook = (IOuterHook)((Object)wire);
            this.outerHooks.add((IOuterHook)hook);
        }
        if (wire instanceof ISolverHook) {
            hook = (ISolverHook)((Object)wire);
            boolean isFull = true;
            for (IElectricNode coupled : hook.coupledNodes()) {
                if (!this.isLeaf(coupled)) continue;
                isFull = false;
                break;
            }
            if (isFull) {
                this.innerHooks.add((ISolverHook)hook);
            } else {
                this.leafInnerHooks.add((ISolverHook)hook);
            }
        }
        if (wire instanceof IStaticResidual) {
            IStaticResidual residual = (IStaticResidual)((Object)wire);
            this.residuals.add(residual);
        }
        this.converged = false;
        this.warmUp(1);
    }

    public void updateConductance(AbstractElectricWire wire, double change) {
        if (this.JacobianKept == null || this.dirty || change == 0.0) {
            return;
        }
        if (this.leafNodes.containsKey(wire.node1) || this.leafNodes.containsKey(wire.node2)) {
            return;
        }
        this.conductanceDelta += Math.abs(change);
        if (this.countUpdates) {
            ++this.conductanceUpdates;
            if (wire.node1 != null && wire.node1.getIndex() >= this.eliminatedStart || wire.node2 != null && wire.node2.getIndex() >= this.eliminatedStart) {
                ++this.eliminatedUpdates;
            }
        }
        wire.stamp(this::jacobianAdd, change);
    }

    public void alterConductanceMatrix(int row, int column, double change) {
        if (this.JacobianKept == null || this.dirty) {
            return;
        }
        this.jacobianAdd(row, column, change);
    }

    public void removeWire(AbstractElectricWire wire) {
        Object hook;
        if (!this.wires.contains(wire)) {
            return;
        }
        this.wires.remove(wire);
        wire.setNetwork(null);
        if (wire instanceof CapacitorWire) {
            --this.sourceCount;
        }
        if (wire.node1 == null || wire.node2 == null) {
            --this.groundReferenceCount;
        }
        this.updateConductance(wire, -wire.conductance());
        if (wire instanceof IOuterHook) {
            hook = (IOuterHook)((Object)wire);
            this.outerHooks.remove(hook);
        }
        if (wire instanceof ISolverHook) {
            hook = (ISolverHook)((Object)wire);
            this.innerHooks.remove(hook);
            this.leafInnerHooks.remove(hook);
        }
        if (wire instanceof IStaticResidual) {
            IStaticResidual residual = (IStaticResidual)((Object)wire);
            this.residuals.remove(residual);
        }
        this.warmUp(1);
    }

    public void updateResistance(AbstractElectricWire wire, double oldResistance) {
        double change = wire.conductance();
        if (oldResistance != 0.0) {
            change -= 1.0 / oldResistance;
        }
        this.updateConductance(wire, change);
    }

    public Collection<INode> getNodes() {
        return this.nodes;
    }

    public DMatrixRMaj getStateVector() {
        return this.StateVector;
    }

    protected void jacobianAdd(int row, int column, double value) {
        if (value == 0.0) {
            return;
        }
        if (row >= this.nodes.size() || column >= this.nodes.size()) {
            throw new IllegalArgumentException("Provided entry lays outside of the allocated matrices.");
        }
        this.recalculateScales = true;
        if (row < this.eliminatedStart && column < this.eliminatedStart) {
            this.JacobianKept.add(row, column, value);
            if (this.ReducedJacobian != null) {
                this.ReducedJacobian.add(row, column, value);
            }
        } else if (!this.lockEliminated) {
            if (row < this.eliminatedStart) {
                this.JacobianRight.add(row, column - this.eliminatedStart, value);
                this.eliminatedChanged = true;
            } else if (column < this.eliminatedStart) {
                this.JacobianBottom.add(row - this.eliminatedStart, column, value);
                this.eliminatedChanged = true;
            } else {
                this.JacobianEliminated.add(row - this.eliminatedStart, column - this.eliminatedStart, value);
                this.eliminatedChanged = true;
            }
        }
    }

    protected void rhsAdd(int row, double value) {
        if (value == 0.0) {
            return;
        }
        if (row < this.eliminatedStart) {
            this.ReducedRHSVector.add(row, 0, value);
        } else {
            this.EliminatedRHSVector.add(row - this.eliminatedStart, 0, value);
            this.eliminatedRHSZero = false;
        }
    }

    protected void populateConductanceMatrix(boolean withEliminated) {
        this.conductanceDelta = 0.0;
        this.conductanceUpdates = 0;
        this.JacobianKept.denseZero();
        if (this.JacobianEliminated != null && withEliminated) {
            this.JacobianEliminated.denseZero();
            this.JacobianBottom.denseZero();
            this.JacobianRight.denseZero();
        }
        this.lockEliminated = !withEliminated;
        ArrayList<AbstractElectricWire> staleWires = new ArrayList<AbstractElectricWire>();
        for (AbstractElectricWire wire2 : this.wires) {
            double G = wire2.conductance();
            if (!Double.isFinite(G)) continue;
            boolean skip = false;
            for (IElectricNode node : wire2.coupledNodes()) {
                if (this.leafNodes.containsKey(node)) {
                    skip = true;
                    break;
                }
                if (node == null) continue;
                if (this.nodes.contains(node)) {
                    if (node.getIndex() < this.nodes.size()) continue;
                    if (LOGGER != null) {
                        LOGGER.warn("Node {} has an index outside of the allocated matrix size, skipping", (Object)node);
                    }
                    skip = true;
                    break;
                }
                if (this.leafNodes.containsKey(node)) continue;
                if (LOGGER != null) {
                    LOGGER.warn("Dropped a stale wire (wire nodes not part of this network) between {}.", wire2.coupledNodes());
                }
                staleWires.add(wire2);
                skip = true;
                break;
            }
            if (skip) continue;
            wire2.stamp(this::jacobianAdd, G);
        }
        staleWires.forEach(wire -> {
            Object hook;
            if (wire instanceof IOuterHook) {
                hook = (IOuterHook)((Object)wire);
                this.outerHooks.remove(hook);
            }
            if (wire instanceof ISolverHook) {
                hook = (ISolverHook)((Object)wire);
                this.innerHooks.remove(hook);
                this.leafInnerHooks.remove(hook);
            }
            if (wire instanceof IStaticResidual) {
                IStaticResidual residual = (IStaticResidual)((Object)wire);
                this.residuals.remove(residual);
            }
            this.wires.remove(wire);
        });
        for (ICouplingNode node : this.couplings) {
            try {
                node.couple(this::jacobianAdd);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LOGGER.error("Failed to couple {}:", (Object)node, (Object)e);
            }
        }
        this.lockEliminated = false;
        if (this.addGMin) {
            boolean shouldAnchor = true;
            ElectricNode anchor = null;
            for (INode node : this.nodes) {
                if (node instanceof CurrentSourceNode) {
                    shouldAnchor = false;
                    continue;
                }
                if (node instanceof VoltageSourceCoupling) {
                    FloatingNode floating;
                    IElectricNode iElectricNode;
                    VoltageSourceCoupling source = (VoltageSourceCoupling)node;
                    if (anchor != null || !((iElectricNode = source.getNegative()) instanceof FloatingNode) || (floating = (FloatingNode)iElectricNode).getIndex() >= this.eliminatedStart) continue;
                    anchor = floating;
                    continue;
                }
                if (!(node instanceof FloatingNode)) continue;
                if (node.getIndex() < this.eliminatedStart) {
                    this.JacobianKept.add(node.getIndex(), node.getIndex(), 1.0E-8);
                    continue;
                }
                if (!withEliminated) continue;
                this.JacobianEliminated.add(node.getIndex() - this.eliminatedStart, node.getIndex() - this.eliminatedStart, 1.0E-8);
            }
            if (this.groundReferenceCount == 0 && shouldAnchor && anchor != null) {
                this.JacobianKept.add(anchor.getIndex(), anchor.getIndex(), 1000.0);
            }
        }
        this.JacobianKept.optimize();
        if (withEliminated) {
            this.eliminatedUpdates = 0;
            this.calculateEliminatedMatrices();
        } else if (this.ReducedCorrection != null) {
            this.JacobianKept.subtract(this.ReducedCorrection, this.ReducedJacobian);
            this.ReducedJacobian.optimize();
        }
        this.recalculateScales = true;
    }

    private void calculateEliminatedMatrices() {
        if (this.JacobianEliminated != null) {
            this.ReducedCorrection.optimize();
            this.JacobianEliminated.convert(this.ReducedCorrection.getState());
            this.JacobianBottom.convert(this.ReducedCorrection.getState());
            this.JacobianRight.convert(this.ReducedCorrection.getState());
            this.WMatrix.convert(this.ReducedCorrection.getState());
            this.JacobianEliminated.refactorize();
            this.JacobianEliminated.solve(this.JacobianBottom, this.WMatrix);
            this.JacobianRight.mult(this.WMatrix, this.ReducedCorrection);
            this.JacobianKept.subtract(this.ReducedCorrection, this.ReducedJacobian);
            this.ReducedJacobian.optimize();
            this.recalculateScales = true;
        }
        this.eliminatedChanged = false;
    }

    public void merge(ElectricalNetwork other) {
        other.leafNodes.forEach((node, tracked) -> {
            node.setNetwork(this);
            this.leafNodes.put((IElectricNode)node, (IElectricNode)tracked);
        });
        other.nodes.forEach(this::addNode);
        other.wires.forEach(this::addWire);
        other.clear();
    }

    public void clear() {
        this.nodes.clear();
        this.wires.clear();
        this.couplings.clear();
        this.innerHooks.clear();
        this.residuals.clear();
        this.leafNodes.clear();
        this.eliminatedStart = 0;
    }

    public double getValue(INode node) {
        if (this.StateVector == null) {
            return 0.0;
        }
        if (this.leafNodes.containsKey(node)) {
            IElectricNode tracked = this.leafNodes.get(node);
            if (tracked != null) {
                return this.getValue(tracked);
            }
            return 0.0;
        }
        int index = node.getIndex();
        if (index < 0 || index >= this.nodes.size()) {
            return 0.0;
        }
        if (index >= this.eliminatedStart) {
            if (this.WMatrix == null || index - this.eliminatedStart >= this.WMatrix.getNumRows()) {
                return 0.0;
            }
            double value = this.eliminatedSolved ? this.EliminatedSolved.get(index - this.eliminatedStart, 0) : 0.0;
            for (int i = 0; i < this.StateVector.getNumRows(); ++i) {
                value -= this.WMatrix.get(index - this.eliminatedStart, i) * this.StateVector.get(i, 0);
            }
            return value;
        }
        if (index >= this.StateVector.getNumRows()) {
            return 0.0;
        }
        double value = this.StateVector.get(index);
        return Double.isFinite(value) ? value : 0.0;
    }

    private void validateJacobian(DynamicallyTypedMatrix jacobian, DMatrixRMaj residual) {
        int n = jacobian.getNumRows();
        DMatrixRMaj v = new DMatrixRMaj(n, 1);
        RandomMatrices_DDRM.fillUniform((DMatrixRMaj)v, (Random)new Random());
        double epsilon = Math.sqrt(Math.ulp(1.0f)) * (1.0 + NormOps_DDRM.normP1((DMatrixRMaj)this.StateVector));
        DMatrixRMaj left = new DMatrixRMaj(n, 1);
        jacobian.mult(v, left);
        this.computeResidual(jacobian, this.StateVector);
        DMatrixRMaj residualBase = new DMatrixRMaj(residual);
        DMatrixRMaj state2 = new DMatrixRMaj(n, 1);
        CommonOps_DDRM.add((DMatrixD1)this.StateVector, (double)epsilon, (DMatrixD1)v, (DMatrixD1)state2);
        this.computeResidual(jacobian, state2);
        DMatrixRMaj right = new DMatrixRMaj(n, 1);
        CommonOps_DDRM.subtract((DMatrixD1)residual, (DMatrixD1)residualBase, (DMatrixD1)right);
        CommonOps_DDRM.scale((double)(1.0 / epsilon), (DMatrixD1)right);
        CommonOps_DDRM.subtract((DMatrixD1)left, (DMatrixD1)right, (DMatrixD1)left);
        if (LOGGER != null) {
            LOGGER.warn("Jacobian validation: {}", (Object)NormOps_DDRM.normP1((DMatrixRMaj)left));
        } else {
            System.out.printf("Jacobian validation: %g\n", NormOps_DDRM.normP1((DMatrixRMaj)left));
        }
    }

    private void swapNodes(INode node1, INode node2) {
        int index1 = node1.getIndex();
        int index2 = node2.getIndex();
        this.nodes.set(index1, node2);
        this.nodes.set(index2, node1);
        if (this.StateVector != null) {
            int size = this.StateVector.getNumRows();
            if (index1 < size && index2 < size) {
                double node2Value = this.StateVector.get(index2, 0);
                this.StateVector.set(index2, 0, this.StateVector.get(index1, 0));
                this.StateVector.set(index1, 0, node2Value);
            } else if (index1 < size) {
                this.StateVector.set(index1, 0, 0.0);
            } else if (index2 < size) {
                this.StateVector.set(index2, 0, 0.0);
            }
        }
        node1.assignIndex(index2);
        node2.assignIndex(index1);
        this.dirty = true;
    }

    public void optimizeNode(@NotNull INode node) {
        if (this.leafNodes.containsKey(node)) {
            return;
        }
        assert (node.getNetwork() == this) : "Node is not part of this network";
        if (node.getIndex() >= this.eliminatedStart) {
            return;
        }
        if (node.getIndex() == this.eliminatedStart - 1) {
            --this.eliminatedStart;
            this.dirty = true;
        } else {
            INode other = this.nodes.get(--this.eliminatedStart);
            this.swapNodes(node, other);
        }
    }

    public void unoptimizeNode(@NotNull INode node) {
        if (this.leafNodes.containsKey(node)) {
            return;
        }
        assert (node.getNetwork() == this) : "Node is not part of this network";
        if (node.getIndex() < this.eliminatedStart) {
            return;
        }
        if (node.getIndex() == this.eliminatedStart) {
            ++this.eliminatedStart;
            this.dirty = true;
        } else {
            INode other = this.nodes.get(++this.eliminatedStart);
            this.swapNodes(node, other);
        }
    }

    public void makeLeaf(IElectricNode node, IElectricNode tracked) {
        assert (node != tracked);
        if (this.nodes.contains(node)) {
            this.internalRemoveNode(node);
            this.leafNodes.put(node, tracked);
            node.setNetwork(this);
            Iterator<ISolverHook> iter = this.innerHooks.iterator();
            while (iter.hasNext()) {
                ISolverHook hook = iter.next();
                for (IElectricNode coupled : hook.coupledNodes()) {
                    if (node != coupled) continue;
                    this.leafInnerHooks.add(hook);
                    iter.remove();
                }
            }
        } else if (this.leafNodes.containsKey(node)) {
            this.leafNodes.put(node, tracked);
        }
    }

    public void removeLeaf(IElectricNode node) {
        if (!this.nodes.contains(node) && this.leafNodes.containsKey(node)) {
            this.leafNodes.remove(node);
            this.addNode((INode)node);
            Iterator<ISolverHook> iter = this.leafInnerHooks.iterator();
            while (iter.hasNext()) {
                ISolverHook hook = iter.next();
                boolean isFull = true;
                for (IElectricNode coupled : hook.coupledNodes()) {
                    if (!this.isLeaf(coupled)) continue;
                    isFull = false;
                    break;
                }
                if (!isFull) continue;
                this.innerHooks.add(hook);
                iter.remove();
            }
        }
    }

    public boolean isLeaf(IElectricNode node) {
        return this.leafNodes.containsKey(node);
    }

    public void unoptimizeAll() {
        if (this.eliminatedStart != this.nodes.size()) {
            this.eliminatedStart = this.nodes.size();
            this.dirty = true;
        }
    }

    public boolean isOptimized(INode node) {
        return node.getIndex() >= this.eliminatedStart;
    }

    private int eliminatedNodeCount() {
        return this.nodes.size() - this.eliminatedStart;
    }

    private void prepareMatrices() {
        boolean shouldReallocate;
        ++this.scalesAge;
        int nodeCount = this.nodes.size();
        int eliminatedCount = this.eliminatedNodeCount();
        int reducedCount = nodeCount - eliminatedCount;
        boolean bl = shouldReallocate = this.JacobianKept == null || this.dirty || this.JacobianKept.getNumRows() != reducedCount || eliminatedCount != 0 && (this.JacobianEliminated == null || this.JacobianEliminated.getNumRows() != eliminatedCount);
        if (shouldReallocate) {
            DMatrixRMaj NewState = new DMatrixRMaj(reducedCount, 1);
            if (this.StateVector != null) {
                for (int i = 0; i < reducedCount; ++i) {
                    NewState.set(i, 0, this.getValue(this.nodes.get(i)));
                }
            }
            this.JacobianKept = new DynamicallyTypedMatrix(reducedCount, reducedCount);
            if (eliminatedCount != 0) {
                this.JacobianEliminated = new DynamicallyTypedMatrix(eliminatedCount, eliminatedCount);
                this.JacobianBottom = new DynamicallyTypedMatrix(eliminatedCount, reducedCount);
                this.JacobianRight = new DynamicallyTypedMatrix(reducedCount, eliminatedCount);
                this.WMatrix = new DynamicallyTypedMatrix(eliminatedCount, reducedCount);
                this.ReducedCorrection = new DynamicallyTypedMatrix(reducedCount, reducedCount);
                this.ReducedJacobian = new DynamicallyTypedMatrix(reducedCount, reducedCount);
                this.EliminatedRHSVector = new DMatrixRMaj(eliminatedCount, 1);
                this.EliminatedSolved = new DMatrixRMaj(eliminatedCount, 1);
            } else {
                this.JacobianEliminated = null;
                this.JacobianBottom = null;
                this.JacobianRight = null;
                this.WMatrix = null;
                this.ReducedCorrection = null;
                this.ReducedJacobian = null;
                this.EliminatedRHSVector = null;
                this.EliminatedSolved = null;
            }
            this.ReducedRHSVector = new DMatrixRMaj(reducedCount, 1);
            this.ScaledJ = new DynamicallyTypedMatrix(reducedCount, reducedCount, DynamicallyTypedMatrix.Solver.LU);
            this.ResidualVector = new DMatrixRMaj(reducedCount, 1);
            this.AuxiliaryVector = new DMatrixRMaj(reducedCount, 1);
            this.StateVector = NewState;
            this.columnScales = new double[reducedCount];
            this.rowScales = new double[reducedCount];
            this.solver.setStateSize(reducedCount);
            this.dirty = false;
            this.populateConductanceMatrix(true);
            this.scalesAge = 21;
        } else if (this.conductanceUpdates >= 500 || this.conductanceDelta > 1000.0 || this.eliminatedUpdates >= 100) {
            if (LOGGER != null && ModdedConfigs.logsEnabled()) {
                LOGGER.debug("Cumulated conductance updates triggered admittance matrix recalculation");
            }
            this.populateConductanceMatrix(this.eliminatedUpdates >= 100);
        }
    }

    private DynamicallyTypedMatrix getWorkMatrix() {
        DynamicallyTypedMatrix workMatrix;
        if (this.ReducedJacobian != null) {
            workMatrix = this.ReducedJacobian;
            if (this.eliminatedChanged) {
                this.calculateEliminatedMatrices();
                this.computeRHS();
            }
        } else {
            workMatrix = this.JacobianKept;
        }
        return workMatrix;
    }

    private void prepareScaled(DynamicallyTypedMatrix workMatrix) {
        if (this.scalesAge >= 20) {
            this.computeScales(workMatrix);
            this.recalculateScales = true;
        }
        if (this.recalculateScales) {
            workMatrix.multColumns(this.columnScales, this.ScaledJ);
            this.ScaledJ.multRows(this.rowScales, null);
            this.ScaledJ.refactorize();
            this.recalculateScales = false;
        }
    }

    private void computeRHS() {
        this.ReducedRHSVector.zero();
        if (this.EliminatedRHSVector != null) {
            this.EliminatedRHSVector.zero();
        }
        this.eliminatedRHSZero = true;
        for (IStaticResidual residual : this.residuals) {
            boolean skip = false;
            for (INode node : residual.affectedNodes()) {
                if (!this.leafNodes.containsKey(node)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            residual.addStaticResidual(this::rhsAdd);
        }
        if (this.EliminatedRHSVector != null && !this.eliminatedRHSZero) {
            this.JacobianEliminated.solve(this.EliminatedRHSVector, this.EliminatedSolved);
            this.JacobianRight.mult(this.EliminatedSolved, this.AuxiliaryVector);
            CommonOps_DDRM.subtract((DMatrixD1)this.ReducedRHSVector, (DMatrixD1)this.AuxiliaryVector, (DMatrixD1)this.ReducedRHSVector);
            this.eliminatedSolved = true;
        } else {
            this.eliminatedSolved = false;
        }
    }

    protected void residualAdd(int row, double value) {
        if (row >= this.ResidualVector.getNumRows()) {
            return;
        }
        this.ResidualVector.add(row, 0, value);
    }

    public void computeResidual(DynamicallyTypedMatrix workMatrix, DMatrixRMaj state) {
        workMatrix.mult(state, this.ResidualVector);
        CommonOps_DDRM.subtract((DMatrixD1)this.ResidualVector, (DMatrixD1)this.ReducedRHSVector, (DMatrixD1)this.ResidualVector);
        for (ISolverHook hook : this.innerHooks) {
            hook.addResidual(this::residualAdd);
        }
    }

    private void columnScales(DynamicallyTypedMatrix matrix) {
        int n = matrix.getNumRows();
        for (int i = 0; i < n; ++i) {
            double max = 0.0;
            for (int j = 0; j < n; ++j) {
                double v = Math.abs(matrix.get(j, i));
                max += v * v;
            }
            this.columnScales[i] = max == 0.0 ? 1.0 : Math.min(1.0 / Math.sqrt(max), 2000.0);
        }
    }

    private void rowScales(DynamicallyTypedMatrix matrix) {
        int n = matrix.getNumRows();
        for (int i = 0; i < n; ++i) {
            if (this.nodes.get(i) instanceof ICouplingNode) {
                this.rowScales[i] = 1.0;
                continue;
            }
            double max = 0.0;
            for (int j = 0; j < n; ++j) {
                double v = Math.abs(matrix.get(i, j));
                max += v * v;
            }
            this.rowScales[i] = max == 0.0 ? 1.0 : Math.min(1.0 / Math.sqrt(max), 2000.0);
        }
    }

    private void computeScales(DynamicallyTypedMatrix workMatrix) {
        this.columnScales(workMatrix);
        workMatrix.multColumns(this.columnScales, this.ScaledJ);
        this.rowScales(this.ScaledJ);
        this.scalesAge = 0;
    }

    public List<INode> findProblematicNodes(DMatrixRMaj residual, double threshold) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (INode node : this.nodes) {
            double x;
            if (node.getIndex() >= this.eliminatedStart || !(Math.abs(x = residual.get(node.getIndex(), 0)) > threshold)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private void iterHooks(int i, int max, double norm) {
        if (this.hasHooks() && i < max - 10 && i % 2 == 0) {
            this.countUpdates = false;
            for (ISolverHook hook : this.innerHooks) {
                hook.startIteration();
            }
            this.countUpdates = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void calculate() {
        void var2_11;
        if (this.sourceCount == 0) {
            this.converged = true;
            for (IOuterHook iOuterHook : this.outerHooks) {
                iOuterHook.preSolve();
            }
            for (ISolverHook iSolverHook : this.innerHooks) {
                iSolverHook.startIteration();
            }
            if (this.StateVector != null) {
                this.StateVector.zero();
            }
            for (IOuterHook iOuterHook : this.outerHooks) {
                iOuterHook.postUpperSolve();
            }
            return;
        }
        for (IOuterHook iOuterHook : this.outerHooks) {
            iOuterHook.preSolve();
        }
        this.prepareMatrices();
        if (this.eliminatedChanged) {
            this.calculateEliminatedMatrices();
        }
        this.computeRHS();
        PERF.start();
        int maxIterations = this.maxIterations.apply(this.hasHooks());
        double norm = 0.0;
        boolean bl = false;
        while (var2_11 < maxIterations) {
            this.iterHooks((int)var2_11, maxIterations, norm);
            DynamicallyTypedMatrix workMatrix = this.getWorkMatrix();
            this.computeResidual(workMatrix, this.StateVector);
            norm = NormOps_DDRM.normP1((DMatrixRMaj)this.ResidualVector);
            if (norm < 1.0E-7) break;
            this.prepareScaled(workMatrix);
            this.AuxiliaryVector.setTo((DMatrixD1)this.ResidualVector);
            CommonOps_DDRM.multRows((double[])this.rowScales, (DMatrixRMaj)this.AuxiliaryVector);
            DMatrixRMaj deltaX = this.solver.solve(this.ScaledJ, this.AuxiliaryVector, false);
            if (deltaX != null) {
                boolean valid;
                boolean bl2 = valid = !MatrixFeatures_DDRM.hasUncountable((DMatrixD1)deltaX);
                if (valid) {
                    double alpha = var2_11 < 4 ? 0.75 : 1.0;
                    boolean applied = false;
                    CommonOps_DDRM.multRows((double[])this.columnScales, (DMatrixRMaj)deltaX);
                    DMatrixRMaj PrevState = this.StateVector;
                    this.StateVector = this.AuxiliaryVector;
                    while (alpha > 1.0E-4) {
                        CommonOps_DDRM.add((DMatrixD1)PrevState, (double)(-alpha), (DMatrixD1)deltaX, (DMatrixD1)this.StateVector);
                        this.iterHooks((int)var2_11, maxIterations, norm);
                        workMatrix = this.getWorkMatrix();
                        this.computeResidual(workMatrix, this.StateVector);
                        double newNorm = NormOps_DDRM.normP1((DMatrixRMaj)this.ResidualVector);
                        if (newNorm < norm) {
                            applied = true;
                            PrevState.setTo((DMatrixD1)this.AuxiliaryVector);
                            break;
                        }
                        if (alpha > 1.0) {
                            alpha = 1.0;
                            continue;
                        }
                        alpha *= 0.5;
                    }
                    this.StateVector = PrevState;
                    if (!applied && !this.hasHooks()) {
                        break;
                    }
                } else {
                    this.StateVector.zero();
                    this.solver.zero();
                }
            }
            ++var2_11;
        }
        if (norm > 1.0E-7) {
            this.converged = false;
            if (LOGGER != null) {
                if (ModdedConfigs.logsEnabled()) {
                    LOGGER.warn("Solution possibly not converged after {} Newton iterations, final norm: {}", (Object)((int)var2_11), (Object)norm);
                }
            } else {
                System.out.printf("Solution possibly not converged after %d Newton iterations, final norm: %g\n", (int)var2_11, norm);
            }
        } else {
            boolean bl3 = this.converged = var2_11 < maxIterations - 10;
            if (!this.converged) {
                if (LOGGER != null) {
                    LOGGER.debug("Dirty converge at {} iterations", (Object)((int)var2_11));
                } else {
                    System.out.printf("Solution possibly not converged (residual recalculation was disabled) after %d Newton iterations\n", (int)var2_11);
                }
            } else if (LOGGER == null) {
                System.out.printf("Converged after %d iterations\n", (int)var2_11);
            }
            if (this.converged && this.warmUpTicks > 0) {
                --this.warmUpTicks;
                this.converged = false;
            }
        }
        PERF.end();
        for (IOuterHook hook : this.outerHooks) {
            hook.postUpperSolve();
        }
    }
}

