/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IOuterHook;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.ISolverHook;

public class CapacitorWire
extends AbstractElectricWire
implements ISolverHook,
IOuterHook {
    private double capacitance;
    private double Ieq;
    private double V;

    public CapacitorWire(double capacitance, IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
        this.capacitance = capacitance;
    }

    @Override
    public double conductance() {
        return 2.0 * this.capacitance / (double)0.05f;
    }

    public void setVoltage(float voltage) {
        this.valueChange(voltage, this.V);
        if (Float.isFinite(voltage)) {
            this.V = voltage;
        }
    }

    @Override
    public float current() {
        return (float)((double)super.current() + this.Ieq);
    }

    @Override
    public void postUpperSolve() {
        if (this.isConverged()) {
            this.V = this.potentialDifference();
        }
    }

    @Override
    public void startIteration() {
        double G = this.conductance();
        double I = this.capacitance * ((double)this.potentialDifference() - this.V) / (double)0.05f;
        this.Ieq = (-G * this.V - I) * 0.99999;
    }

    @Override
    public void addResidual(IResidualAdder residual) {
        if (this.node1 != null) {
            residual.add(this.node1.getIndex(), this.Ieq);
        }
        if (this.node2 != null) {
            residual.add(this.node2.getIndex(), -this.Ieq);
        }
    }
}

