/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IOuterHook;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.ISolverHook;

public class LRSeriesWire
extends AbstractElectricWire
implements ISolverHook,
IOuterHook {
    private double inductance;
    private double resistance;
    private double Ieq;
    private double I;
    private double residualScale;

    public LRSeriesWire(double L, double R, IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
        this.inductance = L;
        this.resistance = R;
        double R_Inductor = 2.0 * this.inductance / 0.05;
        double G_I = 1.0 / R_Inductor;
        this.residualScale = 1.0 - G_I / (1.0 / this.resistance + G_I);
    }

    @Override
    public double conductance() {
        return 1.0 / (this.resistance + 2.0 * this.inductance / 0.05);
    }

    @Override
    public float current() {
        return (float)((double)super.current() + this.Ieq);
    }

    public void setCurrent(float current) {
        this.valueChange(current, this.I);
        if (Float.isFinite(current)) {
            this.I = current;
        }
    }

    @Override
    public void postUpperSolve() {
        if (this.isConverged()) {
            this.I = this.current();
        }
    }

    @Override
    public void startIteration() {
        if (this.inductance == 0.0) {
            this.Ieq = 0.0;
            return;
        }
        double G_I = 0.05 / (2.0 * this.inductance);
        double V_Inductor = this.inductance * ((double)this.current() - this.I) / (double)0.05f;
        this.Ieq = (V_Inductor * G_I + this.I) * this.residualScale;
    }

    @Override
    public void addResidual(IResidualAdder residual) {
        if (this.node1 != null) {
            residual.add(this.node1.getIndex(), this.Ieq);
        }
        if (this.node2 != null) {
            residual.add(this.node2.getIndex(), -this.Ieq);
        }
    }

    public void setLR(double L, double R) {
        double oldConductance = this.conductance();
        this.inductance = L;
        this.resistance = R;
        double R_Inductor = 2.0 * this.inductance / 0.05;
        double G_I = 1.0 / R_Inductor;
        this.residualScale = 1.0 - G_I / (1.0 / this.resistance + G_I);
        if (this.network != null) {
            this.network.updateConductance(this, this.conductance() - oldConductance);
        }
    }

    public void setInductance(double L) {
        this.setLR(L, this.resistance);
    }

    public void setResistance(double R) {
        this.setLR(this.inductance, R);
    }
}

