/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;

public class BlockWireEntityEndpoint
implements IWireEndpoint {
    private BlockPos entityPos;
    private UUID entityId;
    private boolean end;

    public BlockWireEntityEndpoint() {
        this.entityPos = null;
        this.entityId = null;
        this.end = false;
    }

    public BlockWireEntityEndpoint(BlockWireEntity entity, boolean end) {
        this.entityPos = entity.m_20183_();
        this.entityId = entity.m_20148_();
        this.end = end;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.BLOCK_WIRE;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.entityId = nbt.m_128342_("Id");
        int[] posArray = nbt.m_128465_("Pos");
        this.entityPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.end = nbt.m_128471_("End");
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128362_("Id", this.entityId);
        nbt.m_128385_("Pos", new int[]{this.entityPos.m_123341_(), this.entityPos.m_123342_(), this.entityPos.m_123343_()});
        nbt.m_128379_("End", this.end);
    }

    public BlockWireEntity getEntity(Level world) {
        List entityList = world.m_6443_(BlockWireEntity.class, new AABB(this.entityPos), e -> e.m_20148_().equals(this.entityId));
        if (entityList.isEmpty()) {
            return null;
        }
        return (BlockWireEntity)entityList.get(0);
    }

    @Override
    @NotNull
    public Vec3 getExactPosition(Level world) {
        BlockWireEntity entity = this.getEntity(world);
        if (entity == null) {
            return this.entityPos.m_252807_();
        }
        if (!this.end) {
            return entity.m_20182_();
        }
        Vec3 pos = entity.m_20182_();
        for (BlockWireEntity.Point segment : entity.segments) {
            pos = pos.m_82549_(segment.vector());
        }
        return pos;
    }

    public boolean getEnd() {
        return this.end;
    }

    @Override
    public OwnedFloatingNode getNode(Level world) {
        return null;
    }

    @Override
    public void assignWireEntity(BaseWireEntity entity) {
    }

    @Override
    public void removeWireEntity(BaseWireEntity entity) {
    }
}

