/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;

@OnlyIn(value=Dist.CLIENT)
public class BlockWireRenderer
extends EntityRenderer<BlockWireEntity> {
    public BlockWireRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(BlockWireEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (entity.isOverheated()) {
            return;
        }
        Vec3 currentPos = Vec3.f_82478_;
        VertexConsumer buffer = vertexConsumers.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(entity)));
        Vec3 pos = entity.m_20182_();
        int color = entity.getColor() | 0xFF000000;
        boolean first = true;
        for (BlockWireEntity.Point segment : entity.segments) {
            float length = segment.length();
            if (first) {
                currentPos = Vec3.f_82478_.m_231075_(segment.direction, -0.0625);
                length += 0.0625f;
                first = false;
            }
            Vec3i normal = segment.direction.m_122436_();
            Vec3 newPos = currentPos.m_82520_((double)((float)normal.m_123341_() * length), (double)((float)normal.m_123342_() * length), (double)((float)normal.m_123343_() * length));
            int calcLight = 0;
            for (Direction dir : Direction.values()) {
                int skyLight;
                if (dir.m_122434_() == segment.direction.m_122434_()) continue;
                Vec3i n = dir.m_122436_();
                BlockPos blockPos = BlockPos.m_274561_((double)(newPos.f_82479_ + pos.f_82479_ + (double)((float)n.m_123341_() / 16.0f)), (double)(newPos.f_82480_ + pos.f_82480_ + (double)((float)n.m_123342_() / 16.0f)), (double)(newPos.f_82481_ + pos.f_82481_ + (double)((float)n.m_123343_() / 16.0f)));
                int blockLight = entity.m_9236_().m_45517_(LightLayer.BLOCK, blockPos);
                int newLight = LightTexture.m_109885_((int)blockLight, (int)(skyLight = entity.m_9236_().m_45517_(LightLayer.SKY, blockPos)));
                if (newLight <= calcLight) continue;
                calcLight = newLight;
            }
            BlockWireRenderer.renderSegment(matrices, buffer, calcLight, color, currentPos, segment.direction, entity.getWireItem().getWireThickness(), length, entity.m_19879_());
            currentPos = newPos;
        }
    }

    public ResourceLocation getTextureLocation(BlockWireEntity entity) {
        return entity.getWireItem().getWireTexture();
    }

    public static void debugLine(PoseStack ms, VertexConsumer buffer, int light, int color, Vec3 v1, Vec3 v2) {
        Matrix4f matrix = ms.m_85850_().m_252922_();
        buffer.m_252986_(matrix, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_193479_(color).m_85969_(light).m_5752_();
        buffer.m_252986_(matrix, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_193479_(color).m_85969_(light).m_5752_();
    }

    private static void vertex(PoseStack.Pose matrix, VertexConsumer buffer, float x1, float y1, float z1, float u, float v, float xn, float yn, float zn, int color, int light) {
        buffer.m_252986_(matrix.m_252922_(), x1, y1, z1).m_193479_(color).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.m_252943_(), xn, yn, zn).m_5752_();
    }

    public static void renderSegment(PoseStack ms, VertexConsumer buffer, int light, int color, Vec3 start, Direction dir, float thickness, float length, int uvOffset) {
        if (dir.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            length *= -1.0f;
            thickness *= -1.0f;
        }
        float u0 = (float)(uvOffset %= 16) / 16.0f;
        float v0 = (float)uvOffset / 16.0f;
        float t0 = (float)uvOffset / 16.0f;
        float u1 = thickness + (float)uvOffset / 16.0f;
        float v1 = thickness + (float)uvOffset / 16.0f;
        float t1 = thickness + (float)uvOffset / 16.0f;
        float x1 = (float)start.f_82479_ - thickness / 2.0f;
        float y1 = (float)start.f_82480_ - thickness / 2.0f;
        float z1 = (float)start.f_82481_ - thickness / 2.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float z2 = 0.0f;
        switch (dir.m_122434_()) {
            case X: {
                x1 += (thickness *= 0.995f);
                x2 = length - thickness;
                u0 = 0.0f;
                u1 = Math.abs(length);
                break;
            }
            case Y: {
                y1 += thickness;
                y2 = length - thickness;
                v0 = 0.0f;
                v1 = Math.abs(length);
                break;
            }
            case Z: {
                z1 += (thickness *= 1.005f);
                z2 = length - thickness;
                t0 = 0.0f;
                t1 = Math.abs(length);
            }
        }
        x2 += x1 + thickness;
        y2 += y1 + thickness;
        z2 += z1 + thickness;
        if (dir.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            float xb = x1;
            float yb = y1;
            float zb = z1;
            x1 = x2;
            y1 = y2;
            z1 = z2;
            x2 = xb;
            y2 = yb;
            z2 = zb;
        }
        PoseStack.Pose matrix = ms.m_85850_();
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z1, t1, u0, 0.0f, -1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z1, t1, u1, 0.0f, -1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z2, t0, u1, 0.0f, -1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z2, t0, u0, 0.0f, -1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z1, t0, u1, 0.0f, 1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z2, t1, u1, 0.0f, 1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z2, t1, u0, 0.0f, 1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z1, t0, u0, 0.0f, 1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z1, t0, v1, -1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z2, t1, v1, -1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z2, t1, v0, -1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z1, t0, v0, -1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z1, t1, v0, 1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z1, t1, v1, 1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z2, t0, v1, 1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z2, t0, v0, 1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z1, u0, v0, 0.0f, 0.0f, -1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z1, u0, v1, 0.0f, 0.0f, -1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z1, u1, v1, 0.0f, 0.0f, -1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z1, u1, v0, 0.0f, 0.0f, -1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z2, u0, v0, 0.0f, 0.0f, 1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z2, u1, v0, 0.0f, 0.0f, 1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z2, u1, v1, 0.0f, 0.0f, 1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z2, u0, v1, 0.0f, 0.0f, 1.0f, color, light);
    }
}

