/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.network.packets.BlockWireAttachC2SPacket;
import org.patryk3211.powergrid.network.packets.BlockWireCutC2SPacket;
import org.patryk3211.powergrid.utility.Lang;

@OnlyIn(value=Dist.CLIENT)
public class ClientWireInteractions {
    private static BlockWireEntity currentEntity = null;
    private static int firstSegmentIndex;
    private static int firstSegmentPoint;
    private static final RandomSource r;

    public static void clientTick() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target == null || target.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        EntityHitResult entityHit = (EntityHitResult)target;
        if (currentEntity != entityHit.m_82443_()) {
            return;
        }
        Tuple<Integer, Integer> segment = ClientWireInteractions.getSegment(currentEntity, target.m_82450_());
        if (segment != null) {
            int point2;
            int index2;
            int point1;
            int index1;
            if ((Integer)segment.m_14418_() < firstSegmentIndex) {
                index1 = (Integer)segment.m_14418_();
                point1 = (Integer)segment.m_14419_();
                index2 = firstSegmentIndex;
                point2 = firstSegmentPoint;
            } else {
                index1 = firstSegmentIndex;
                index2 = (Integer)segment.m_14418_();
                if (index1 == index2 && (Integer)segment.m_14419_() < firstSegmentPoint) {
                    point1 = (Integer)segment.m_14419_();
                    point2 = firstSegmentPoint;
                } else {
                    point1 = firstSegmentPoint;
                    point2 = (Integer)segment.m_14419_();
                }
            }
            for (int i = index1; i <= index2; ++i) {
                BlockWireEntity.Point wireSegment = ClientWireInteractions.currentEntity.segments.get(i);
                Vec3 start = wireSegment.start;
                Vec3 end = wireSegment.start.m_82549_(wireSegment.vector());
                if (i == index1) {
                    start = wireSegment.start.m_231075_(wireSegment.direction, (double)((float)point1 / 16.0f));
                }
                if (i == index2) {
                    end = wireSegment.start.m_231075_(wireSegment.direction, (double)((float)point2 / 16.0f));
                }
                Vec3 pos = VecHelper.lerp((float)r.m_188501_(), (Vec3)start, (Vec3)end).m_272010_(r, 0.0625f);
                mc.f_91073_.m_7107_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.5f), 0.5f), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    private static Tuple<Integer, Integer> getSegment(BlockWireEntity entity, Vec3 hitPos) {
        Vec3 localPos = hitPos.m_82546_(entity.m_20182_());
        float thickness = entity.getWireItem().getWireThickness();
        for (int i = 0; i < entity.boundingBoxes.size(); ++i) {
            int segmentPoint;
            AABB bb = entity.boundingBoxes.get(i);
            if (!bb.m_82400_((double)(thickness * 0.2f)).m_82390_(localPos)) continue;
            BlockWireEntity.Point segment = entity.segments.get(i);
            switch (segment.direction.m_122434_()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: {
                    int n = (int)Math.round(Math.abs(segment.start.f_82479_ - hitPos.f_82479_) * 16.0);
                    break;
                }
                case Y: {
                    int n = (int)Math.round(Math.abs(segment.start.f_82480_ - hitPos.f_82480_) * 16.0);
                    break;
                }
                case Z: {
                    int n = segmentPoint = (int)Math.round(Math.abs(segment.start.f_82481_ - hitPos.f_82481_) * 16.0);
                }
            }
            if (segmentPoint < 0) {
                segmentPoint = 0;
            } else if (segmentPoint > segment.gridLength) {
                segmentPoint = segment.gridLength;
            }
            return new Tuple((Object)i, (Object)segmentPoint);
        }
        return null;
    }

    public static InteractionResult segmentCut(BlockWireEntity entity) {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target.m_6662_() != HitResult.Type.ENTITY) {
            return InteractionResult.FAIL;
        }
        if (currentEntity != entity) {
            Vec3 hitPos = target.m_82450_();
            Tuple<Integer, Integer> segment = ClientWireInteractions.getSegment(entity, hitPos);
            if (segment != null) {
                firstSegmentIndex = (Integer)segment.m_14418_();
                firstSegmentPoint = (Integer)segment.m_14419_();
                currentEntity = entity;
            }
            return InteractionResult.CONSUME;
        }
        Tuple<Integer, Integer> secondSegment = ClientWireInteractions.getSegment(entity, target.m_82450_());
        if (secondSegment != null) {
            ModdedPackets.sendToServer(new BlockWireCutC2SPacket(entity, firstSegmentIndex, firstSegmentPoint, (Integer)secondSegment.m_14418_(), (Integer)secondSegment.m_14419_()));
            currentEntity = null;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static InteractionResult attachWire(BlockWireEntity entity) {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target.m_6662_() != HitResult.Type.ENTITY) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (entity.getWireItem() != stack.m_41720_()) {
            mc.f_91074_.m_5661_((Component)Lang.translate("message.connection_incorrect_wire_type", new Object[0]).style(ChatFormatting.RED).component(), true);
            return InteractionResult.FAIL;
        }
        Vec3 hitPos = target.m_82450_();
        Tuple<Integer, Integer> segment = ClientWireInteractions.getSegment(entity, hitPos);
        if (segment == null) {
            return InteractionResult.FAIL;
        }
        ModdedPackets.sendToServer(new BlockWireAttachC2SPacket(entity, (Integer)segment.m_14418_(), (Integer)segment.m_14419_()));
        return InteractionResult.SUCCESS;
    }

    static {
        r = RandomSource.m_216327_();
    }
}

