/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;

public abstract class WireEntity
extends BaseWireEntity {
    private ElectricWire wire;

    public WireEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public void setWire(ElectricWire wire) {
        this.wire = wire;
    }

    public ElectricWire getWire() {
        return this.wire;
    }

    @Override
    public float current() {
        return this.wire == null || !this.wire.isConverged() ? 0.0f : this.wire.current();
    }

    @Override
    public void makeWire() {
        Level world = this.m_9236_();
        if (world.f_46443_ && !(world instanceof PonderLevel)) {
            return;
        }
        this.dropWire();
        if (this.endpoint1 == null || this.endpoint2 == null) {
            return;
        }
        if (!this.endpoint1.isValid(world) || !this.endpoint2.isValid(world)) {
            return;
        }
        try {
            this.wire = GlobalElectricNetworks.makeConnection(world, this.endpoint1, this.endpoint2, this, new WorldNetworks.SimpleId(this.m_20148_()));
        }
        catch (RuntimeException e) {
            PowerGrid.LOGGER.error("Failed to create wire for entity", (Throwable)e);
            this.m_6074_();
        }
    }

    @Override
    public void dropWire() {
        if (this.wire != null) {
            this.wire.remove();
            this.wire = null;
        }
    }

    public static void entityUnload(Entity entity, ServerLevel world) {
        if (!(entity instanceof WireEntity)) {
            return;
        }
        WireEntity wire = (WireEntity)entity;
        ElectricWire electricWire = wire.wire;
        if (electricWire instanceof TransmissionLinePart) {
            TransmissionLinePart part = (TransmissionLinePart)electricWire;
            Entity.RemovalReason reason = wire.m_146911_();
            if (reason != null && reason.m_146965_()) {
                wire.dropWire();
            } else {
                part.unload();
                wire.wire = null;
            }
        } else {
            wire.dropWire();
        }
    }
}

