/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedEntities;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.CurveParameters;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.electricity.wire.powercord.CordItem;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.network.packets.EntityDataS2CPacket;
import org.patryk3211.powergrid.utility.IComplexRaycast;

public class CordEntity
extends BaseWireEntity
implements IComplexRaycast {
    private static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);
    public Vec3 terminalPos1;
    public Vec3 terminalPos2;
    private ElectricWire wire1;
    private ElectricWire wire2;
    public Object renderParams;
    private boolean particlesSpawned;

    public static CordEntity create(Level world, ICordEndpoint endpoint1, ICordEndpoint endpoint2, ItemStack item, @Nullable Float resistance) {
        if (!(item.m_41720_() instanceof CordItem)) {
            throw new IllegalArgumentException("ItemStack must be of a CordItem");
        }
        CordEntity entity = new CordEntity((EntityType)ModdedEntities.CORD_ENTITY.get(), world);
        entity.setItem((WireItem)item.m_41720_(), item.m_41613_());
        entity.resistanceOverride = resistance;
        entity.setEndpoint1(endpoint1);
        entity.setEndpoint2(endpoint2);
        entity.refreshTerminalPositions();
        entity.m_146926_(0.0f);
        entity.m_146867_();
        entity.m_20090_();
        if (entity.getWireItem().canBeColored()) {
            entity.setColor(4275249);
        }
        return entity;
    }

    public CordEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public void updateRenderParams() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        WireItem item = this.getWireItem();
        this.renderParams = new CurveParameters(this.terminalPos1, this.terminalPos2, item.getHorizontalCoefficient(), item.getVerticalCoefficient(), item.getWireThickness());
        this.m_20011_(this.m_142242_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public AABB calculateClientBoundingBox() {
        if (this.renderParams == null) {
            return null;
        }
        CurveParameters curve = (CurveParameters)this.renderParams;
        AABB box = new AABB(this.terminalPos1, this.terminalPos2);
        MutableFloat minY = new MutableFloat((Number)box.f_82289_);
        float eY = (float)this.m_20182_().f_82480_;
        curve.runForSegments((x1, y1, z1, x2, y2, z2, offset, length) -> {
            float y = (y1 + y2) * 0.5f + eY;
            if (y < minY.getValue().floatValue()) {
                minY.setValue(y);
            }
        });
        return box.m_165887_((double)minY.getValue().floatValue()).m_82400_((double)0.1f);
    }

    @NotNull
    protected AABB m_142242_() {
        if (this.terminalPos1 != null && this.terminalPos2 != null) {
            AABB box;
            if (this.m_9236_().f_46443_ && (box = this.calculateClientBoundingBox()) != null) {
                return box;
            }
            box = new AABB(this.terminalPos1, this.terminalPos2);
            return box.m_82400_((double)0.1f);
        }
        return super.m_142242_();
    }

    @Override
    public float current() {
        if (this.wire1 == null || this.wire2 == null) {
            return 0.0f;
        }
        if (!this.wire1.isConverged() || !this.wire2.isConverged()) {
            return 0.0f;
        }
        return Math.abs(this.wire1.current()) + Math.abs(this.wire2.current());
    }

    @Override
    public void setEndpoint1(IWireEndpoint endpoint) {
        assert (endpoint == null || endpoint instanceof ICordEndpoint);
        super.setEndpoint1(endpoint);
    }

    @Override
    public void setEndpoint2(IWireEndpoint endpoint) {
        assert (endpoint == null || endpoint instanceof ICordEndpoint);
        super.setEndpoint2(endpoint);
    }

    @Override
    public void makeWire() {
        Level world = this.m_9236_();
        if (world.f_46443_ && !(world instanceof PonderLevel)) {
            return;
        }
        this.dropWire();
        if (this.endpoint1 == null || this.endpoint2 == null) {
            return;
        }
        if (!this.endpoint1.isValid(world) || !this.endpoint2.isValid(world)) {
            return;
        }
        ICordEndpoint cordEnd1 = (ICordEndpoint)this.endpoint1;
        ICordEndpoint cordEnd2 = (ICordEndpoint)this.endpoint2;
        try {
            this.wire1 = GlobalElectricNetworks.makeConnection(world, cordEnd1.getEndpoint1(), cordEnd2.getEndpoint1(), this, new WorldNetworks.ComplexId(this.m_20148_(), 0));
            this.wire2 = GlobalElectricNetworks.makeConnection(world, cordEnd1.getEndpoint2(), cordEnd2.getEndpoint2(), this, new WorldNetworks.ComplexId(this.m_20148_(), 1));
        }
        catch (RuntimeException e) {
            PowerGrid.LOGGER.error("Failed to create wire for entity", (Throwable)e);
            this.m_6074_();
        }
    }

    @Override
    public void dropWire() {
        if (this.wire1 != null) {
            this.wire1.remove();
            this.wire1 = null;
        }
        if (this.wire2 != null) {
            this.wire2.remove();
            this.wire2 = null;
        }
    }

    public void refreshTerminalPositions() {
        Level world = this.m_9236_();
        if (world != null && (!world.f_46443_ || world instanceof PonderLevel)) {
            this.terminalPos1 = this.getEndpoint1().getExactPosition(world);
            this.terminalPos2 = this.getEndpoint2().getExactPosition(world);
            Vec3 vect = this.terminalPos2.m_82546_(this.terminalPos1);
            Vec3 facing = vect.m_82537_(UP);
            float facingAngle = (float)(Math.atan2(facing.f_82479_, -facing.f_82481_) * 180.0 / Math.PI);
            this.m_6034_((this.terminalPos1.f_82479_ + this.terminalPos2.f_82479_) * 0.5, this.terminalPos1.f_82480_, (this.terminalPos1.f_82481_ + this.terminalPos2.f_82481_) * 0.5);
            this.m_146922_(facingAngle);
            if (!world.f_46443_) {
                CompoundTag tag = new CompoundTag();
                ListTag list = new ListTag();
                list.add((Object)FloatTag.m_128566_((float)((float)this.terminalPos1.f_82479_)));
                list.add((Object)FloatTag.m_128566_((float)((float)this.terminalPos1.f_82480_)));
                list.add((Object)FloatTag.m_128566_((float)((float)this.terminalPos1.f_82481_)));
                list.add((Object)FloatTag.m_128566_((float)((float)this.terminalPos2.f_82479_)));
                list.add((Object)FloatTag.m_128566_((float)((float)this.terminalPos2.f_82480_)));
                list.add((Object)FloatTag.m_128566_((float)((float)this.terminalPos2.f_82481_)));
                tag.m_128365_("V", (Tag)list);
                EntityDataS2CPacket packet = new EntityDataS2CPacket(this, tag);
                ModdedPackets.sendToClientsTracking(packet, this);
            }
        }
    }

    @Override
    public void m_8119_() {
        byte beginFlags = this.deferEndpointResolution;
        super.m_8119_();
        Level world = this.m_9236_();
        if (beginFlags != this.deferEndpointResolution) {
            this.terminalPos1 = this.getEndpoint1().getExactPosition(world);
            this.terminalPos2 = this.getEndpoint2().getExactPosition(world);
            this.updateRenderParams();
        }
        float temperature = this.getTemperature();
        Vec3 pos = this.m_20182_();
        if (this.isOverheated()) {
            if (world.f_46443_ && !this.particlesSpawned) {
                CurveParameters curveParams = (CurveParameters)this.renderParams;
                float dx = curveParams.getCurveSpan();
                int pointCount = Math.round(dx / 0.25f);
                curveParams.runForPoints(pointCount, (x, y, z) -> world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_ + (double)x, pos.f_82480_ + (double)y, pos.f_82481_ + (double)z, 0.0, 0.0, 0.0));
                this.particlesSpawned = true;
            }
        } else if (temperature >= this.overheatTemperature - 50.0f && world.f_46443_ && this.renderParams != null) {
            Vec3 curvePoint = ((CurveParameters)this.renderParams).getRandomPoint(this.f_19796_);
            double x2 = curvePoint.f_82479_ + pos.f_82479_;
            double y2 = curvePoint.f_82480_ + pos.f_82480_;
            double z2 = curvePoint.f_82481_ + pos.f_82481_;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x2, y2, z2, 0.0, (double)0.05f, 0.0);
        }
    }

    @Override
    public void endpointRemoved(IWireEndpoint endpoint) {
        if (endpoint.equals(this.getEndpoint1()) || endpoint.equals(this.getEndpoint2())) {
            this.m_6074_();
        }
    }

    public boolean m_6087_() {
        return EnvExecutor.getInEnv((Env)Env.CLIENT, () -> () -> {
            Object patt0$temp = this.renderParams;
            if (patt0$temp instanceof CurveParameters) {
                CurveParameters rp = (CurveParameters)patt0$temp;
                return rp.isVertical();
            }
            return false;
        }).orElse(false);
    }

    @Override
    public void onEntityDataPacket(CompoundTag data) {
        if (data.m_128441_("V")) {
            ListTag list = data.m_128437_("V", 5);
            this.terminalPos1 = new Vec3((double)list.m_128775_(0), (double)list.m_128775_(1), (double)list.m_128775_(2));
            this.terminalPos2 = new Vec3((double)list.m_128775_(3), (double)list.m_128775_(4), (double)list.m_128775_(5));
            this.updateRenderParams();
        } else {
            super.onEntityDataPacket(data);
        }
    }

    @Override
    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (this.getEndpoint1() == null || this.getEndpoint2() == null) {
            this.m_6074_();
            return;
        }
        Level world = this.m_9236_();
        if (!world.f_46443_) {
            this.refreshTerminalPositions();
        } else {
            this.terminalPos1 = this.getEndpoint1().getExactPosition(world);
            this.terminalPos2 = this.getEndpoint2().getExactPosition(world);
            this.updateRenderParams();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec3 raycast(Vec3 min, Vec3 max) {
        if (this.getWireItem() == null) {
            return null;
        }
        float thickness = this.getWireItem().getWireThickness() * 2.0f;
        Object object = this.renderParams;
        if (object instanceof CurveParameters) {
            CurveParameters params = (CurveParameters)object;
            Vec3 ray = max.m_82546_(min);
            double rayLength = ray.m_82556_();
            ray = ray.m_82541_();
            Vec3 planeOrigin = this.m_20182_();
            Vec3 planeNormal = this.m_20252_(1.0f);
            Vec3 planeOriginVector = planeOrigin.m_82546_(min);
            Vec3 planeYVector = new Vec3(0.0, 1.0, 0.0);
            Vec3 planeXVector = planeNormal.m_82537_(planeYVector);
            if (ray.f_82479_ * ray.f_82479_ + ray.f_82481_ * ray.f_82481_ < ray.f_82480_ * ray.f_82480_ * 0.25) {
                double planeDistance = planeOriginVector.m_82526_(planeYVector);
                double hitDistance = planeDistance / planeYVector.m_82526_(ray);
                if (hitDistance * hitDistance < rayLength) {
                    Vec3 hit = min.m_82549_(ray.m_82490_(hitDistance));
                    Vec3 hitOriginVector = hit.m_82546_(planeOrigin);
                    double parallelDistance = Math.abs(planeXVector.m_82526_(hitOriginVector));
                    double perpendicularDistance = Math.abs(planeNormal.m_82526_(hitOriginVector));
                    if (parallelDistance < (double)(params.getCurveSpan() / 2.0f) && perpendicularDistance < (double)(thickness / 2.0f)) {
                        return hit;
                    }
                    return null;
                }
            } else {
                double planeDistance = planeOriginVector.m_82526_(planeNormal);
                double hitDistance = planeDistance / planeNormal.m_82526_(ray);
                if (hitDistance > 0.0 && hitDistance * hitDistance < rayLength) {
                    double dY;
                    Vec3 hit = min.m_82549_(ray.m_82490_(hitDistance));
                    Vec3 hitOriginVector = hit.m_82546_(planeOrigin);
                    double x = planeXVector.m_82526_(hitOriginVector);
                    double y = hitOriginVector.f_82480_;
                    double closeX = params.findClosestPoint(x, y);
                    double span = params.getCurveSpan() / 2.0f;
                    double dX = x - (closeX = Math.min(Math.max(closeX, -span), span));
                    double squareDistance = dX * dX + (dY = y - (double)params.apply((float)closeX)) * dY;
                    if (squareDistance < (double)(thickness * thickness)) {
                        return hit;
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

