/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.portablebattery;

import com.simibubi.create.AllSoundEvents;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.equipment.portablebattery.BatteryUtils;
import org.patryk3211.powergrid.equipment.portablebattery.PortableBatteryBlock;

public class PortableBatteryBlockEntity
extends ElectricBlockEntity
implements Nameable {
    private int charge;
    private int maxCharge;
    private int capacityLevel;
    private SwitchedWire wire;
    private Component name;
    private CompoundTag vanillaTag = new CompoundTag();

    public PortableBatteryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.maxCharge = ((PortableBatteryBlock)state.m_60734_()).capacity();
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.wire.getState() && !this.f_58857_.f_46443_) {
            int prevComparatorLevel = this.getComparatorOutput();
            float fePerTick = Math.abs(this.wire.potentialDifference()) * ModdedConfigs.server().electricity.forgeEnergyPerVolt.getF();
            this.charge = (int)Math.min((float)this.charge + fePerTick, (float)this.maxCharge);
            this.m_6596_();
            if (this.getComparatorOutput() != prevComparatorLevel) {
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                this.sendData();
            }
        }
        this.wire.setState(this.charge < this.maxCharge);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connectSwitch(this.resistance(), builder.terminalNode(0), builder.terminalNode(1), this.charge < this.maxCharge);
    }

    private void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.4f, 1.0f, true);
        Vec3 baseMotion = new Vec3(0.25, 0.1, 0.0);
        Vec3 baseVec = this.f_58858_.m_252807_();
        for (int i = 0; i < 360; i += 10) {
            Vec3 m = VecHelper.rotate((Vec3)baseMotion, (double)i, (Direction.Axis)Direction.Axis.Y);
            m = m.m_272010_(this.f_58857_.f_46441_, 0.2f);
            Vec3 v = baseVec.m_82549_(m.m_82541_().m_82490_(0.25));
            this.f_58857_.m_7106_((ParticleOptions)SparkParticleData.INSTANCE, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        int prev = this.charge;
        this.charge = tag.m_128451_("Charge");
        this.capacityLevel = tag.m_128451_("CapacityLevel");
        this.maxCharge = BatteryUtils.getMaxCharge(this.capacityLevel);
        this.name = tag.m_128441_("CustomName") ? Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")) : null;
        this.vanillaTag = tag.m_128469_("VanillaTag");
        if (prev != 0 && prev != this.charge && this.charge == this.maxCharge && clientPacket) {
            this.playFilledEffect();
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("Charge", this.charge);
        tag.m_128405_("CapacityLevel", this.capacityLevel);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        tag.m_128365_("VanillaTag", (Tag)this.vanillaTag);
    }

    public void setCapacityEnchantLevel(int level) {
        this.capacityLevel = level;
        this.maxCharge = BatteryUtils.getMaxCharge(level);
    }

    public void setCharge(int charge) {
        this.charge = charge;
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    public Component m_7755_() {
        return this.name;
    }

    public void setName(Component name) {
        this.name = name;
    }

    public void setTags(CompoundTag vanillaTag) {
        this.vanillaTag = vanillaTag;
    }

    public CompoundTag getVanillaTag() {
        return this.vanillaTag.m_6426_();
    }

    public int getCharge() {
        return this.charge;
    }

    public int getComparatorOutput() {
        return (int)((float)this.charge / (float)this.maxCharge * 15.0f);
    }
}

