/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.base;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.config.ResistanceValues;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;

public abstract class ElectricKineticBlock
extends KineticBlock
implements IElectric {
    private BlockStateTerminalCollection terminals = null;
    private ImmutableMap<BlockState, VoxelShape> outlines = null;

    public ElectricKineticBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void setTerminalCollection(BlockStateTerminalCollection terminals) {
        this.terminals = terminals;
        Function<BlockState, VoxelShape> mapper = terminals.shapeMapper();
        if (mapper != null) {
            this.outlines = this.m_152458_(mapper);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.outlines != null) {
            return (VoxelShape)this.outlines.get((Object)state);
        }
        return super.m_5940_(state, world, pos, context);
    }

    @Override
    public ITerminalPlacement terminal(BlockState state, int index) {
        if (this.terminals != null) {
            return this.terminals.get(state, index);
        }
        return null;
    }

    @Override
    public int terminalCount() {
        if (this.terminals != null) {
            return this.terminals.count();
        }
        return 0;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        if (result == InteractionResult.SUCCESS && !context.m_43725_().f_46443_) {
            ElectricBlock.refreshConnectionEntities(context.m_43725_(), context.m_8083_());
        }
        return result;
    }

    public float resistance() {
        return ResistanceValues.get((Block)this);
    }

    public float resistance(String suffix) {
        return ResistanceValues.get((Block)this, suffix);
    }
}

