/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.winding;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ProxyElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.special.LRSeriesWire;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.kinetics.generator.winding.IWindingConnectable;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlock;

public class WindingBlockEntity
extends ElectricBlockEntity {
    private BlockPos ownerPosition;
    private Set<BlockPos> parallelPositions;
    private WindingBlockEntity mainBE;
    private Set<WindingBlockEntity> collectedBEs;
    private float resistance = 0.1f;
    private int totalCoilCount = 0;
    private LRSeriesWire coilWire;
    private boolean rebuildParallels = false;

    public WindingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(40);
    }

    public static float coilConstant() {
        return ModdedConfigs.server().kinetics.generatorControls.windingCoilConstant.getF();
    }

    private boolean isMain() {
        return (Integer)this.m_58900_().m_61143_((Property)WindingBlock.PART) == 0;
    }

    public float fieldStrength() {
        WindingBlockEntity be = this.getSimElementHolder();
        if (be == null) {
            return 0.0f;
        }
        float I_sat = ModdedConfigs.server().kinetics.generatorControls.fieldSaturationCurrent.getF();
        float current = be.coilWire.current();
        float B = (current = (float)((double)I_sat * Math.tanh(1.5 * (double)current / (double)I_sat)) + current * 0.05f) * WindingBlockEntity.coilConstant();
        if (B == 0.0f) {
            return 0.001f;
        }
        if (Math.abs(B) < 0.001f) {
            return 0.001f * Math.signum(B);
        }
        return B;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        if (this.isMain()) {
            this.electricBehaviour = new ElectricBehaviour(this);
        } else {
            WindingBlock block = (WindingBlock)this.m_58900_().m_60734_();
            this.electricBehaviour = new ProxyElectricBehaviour(this, () -> block.getMainBlockPos(this.f_58857_, this.f_58858_));
        }
        behaviours.add(this.electricBehaviour);
        this.thermalBehaviour = this.specifyThermalBehaviour();
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        ThermalBehaviour thermal = ThermalBehaviour.fromConfig(this);
        if (thermal != null) {
            thermal.overheatCallback(() -> {
                assert (this.f_58857_ != null);
                WindingBlock block = (WindingBlock)this.m_58900_().m_60734_();
                block.walk((LevelAccessor)this.f_58857_, this.f_58858_, (pos1, state) -> this.f_58857_.m_46961_(pos1, false));
            });
        }
        return thermal;
    }

    private void checkParallelPosition(BlockPos thisPos, Direction side, boolean thisIsOwner) {
        assert (this.f_58857_ != null);
        BlockPos checkPos = thisPos.m_121945_(side);
        BlockState checkState = this.f_58857_.m_8055_(checkPos);
        BlockState thisState = this.f_58857_.m_8055_(thisPos);
        IWindingConnectable thisConnectible = (IWindingConnectable)thisState.m_60734_();
        Block block = checkState.m_60734_();
        if (!(block instanceof IWindingConnectable)) {
            return;
        }
        IWindingConnectable checkConnectible = (IWindingConnectable)block;
        if (!thisConnectible.canConnect(thisState, side)) {
            return;
        }
        if (!checkConnectible.canConnect(checkState, side.m_122424_())) {
            return;
        }
        Block block2 = checkState.m_60734_();
        if (block2 instanceof WindingBlock) {
            WindingBlock windingBlock = (WindingBlock)block2;
            Optional<WindingBlockEntity> be = windingBlock.getMainBlockEntity(this.f_58857_, checkPos);
            be.ifPresent(winding -> {
                if (checkState.m_61143_(WindingBlock.AXIS) == thisState.m_61143_(WindingBlock.AXIS)) {
                    if (thisIsOwner) {
                        this.addParallel((WindingBlockEntity)winding);
                    } else {
                        winding.addParallel(this);
                    }
                }
            });
        } else {
            Direction sideOut = checkConnectible.getOtherSide(checkState, side.m_122424_());
            BlockState checkState2 = this.f_58857_.m_8055_(checkPos = checkPos.m_121945_(sideOut));
            Block block3 = checkState2.m_60734_();
            if (!(block3 instanceof WindingBlock)) {
                return;
            }
            WindingBlock windingBlock = (WindingBlock)block3;
            if (!windingBlock.canConnect(checkState2, sideOut.m_122424_())) {
                return;
            }
            if (!checkConnectible.canConnect(checkState, sideOut)) {
                return;
            }
            Optional<WindingBlockEntity> be = windingBlock.getMainBlockEntity(this.f_58857_, checkPos);
            be.ifPresent(winding -> {
                if (checkState2.m_61143_(WindingBlock.AXIS) == thisState.m_61143_(WindingBlock.AXIS)) {
                    if (thisIsOwner) {
                        this.addParallel((WindingBlockEntity)winding);
                    } else {
                        winding.addParallel(this);
                    }
                }
            });
        }
    }

    @NotNull
    private Collection<TransmissionLinePart> wires() {
        if (this.electricBehaviour == null) {
            return List.of();
        }
        return GlobalElectricNetworks.getWorldNetworks(this.f_58857_).findConnectedWires(this.electricBehaviour);
    }

    private void rewire() {
        if (this.electricBehaviour != null) {
            Collection<TransmissionLinePart> wires = this.wires();
            ElectricBehaviour electricBehaviour = this.electricBehaviour;
            if (electricBehaviour instanceof ProxyElectricBehaviour) {
                ProxyElectricBehaviour proxy = (ProxyElectricBehaviour)electricBehaviour;
                proxy.refreshEndpoints();
            }
            wires.forEach(TransmissionLinePart::refreshEndpointNodes);
        }
    }

    public void addElectricBehaviour() {
        Collection<TransmissionLinePart> wires = this.wires();
        if (this.electricBehaviour == null) {
            this.electricBehaviour = new ElectricBehaviour(this);
            this.attachBehaviourLate(this.electricBehaviour);
        } else {
            ElectricBehaviour electricBehaviour = this.electricBehaviour;
            if (electricBehaviour instanceof ProxyElectricBehaviour) {
                ProxyElectricBehaviour proxy = (ProxyElectricBehaviour)electricBehaviour;
                this.electricBehaviour = new ElectricBehaviour(this);
                this.electricBehaviour.inheritConnections(proxy);
                this.attachBehaviourLate(this.electricBehaviour);
            }
        }
        wires.forEach(TransmissionLinePart::refreshEndpointNodes);
    }

    public void removeElectricBehaviour() {
        Collection<TransmissionLinePart> wires = this.wires();
        ElectricBehaviour old = null;
        if (this.electricBehaviour != null && !(this.electricBehaviour instanceof ProxyElectricBehaviour)) {
            old = this.electricBehaviour;
            this.electricBehaviour = new ProxyElectricBehaviour(this, () -> this.ownerPosition);
            this.electricBehaviour.inheritConnections(old);
            old.pause();
            this.attachBehaviourLate(this.electricBehaviour);
            this.coilWire = null;
        }
        wires.forEach(TransmissionLinePart::refreshEndpointNodes);
        if (old != null) {
            old.remove();
        }
    }

    private void collectWindingParts() {
        assert (this.f_58857_ != null);
        WindingBlock block = (WindingBlock)this.m_58900_().m_60734_();
        Direction.Axis parallelCheckAxis = block.getParallelCheckAxis(this.m_58900_());
        if (this.isMain()) {
            this.mainBE = this;
            this.collectedBEs = new HashSet<WindingBlockEntity>();
            block.walk((LevelAccessor)this.f_58857_, this.f_58858_, (pos1, state) -> {
                Optional opt = this.f_58857_.m_141902_(pos1, (BlockEntityType)ModdedBlockEntities.WINDING.get());
                if (opt.isEmpty()) {
                    this.f_58857_.m_46961_(pos1, false);
                    return;
                }
                WindingBlockEntity be = (WindingBlockEntity)opt.get();
                this.collectedBEs.add(be);
                if (be.collectedBEs != null && be != this) {
                    if (be.ownerPosition != null) {
                        this.f_58857_.m_141902_(be.ownerPosition, (BlockEntityType)ModdedBlockEntities.WINDING.get()).ifPresent(WindingBlockEntity::dissolveParallels);
                    } else if (be.parallelPositions != null) {
                        be.dissolveParallels();
                        be.electricBehaviour.breakConnections();
                        be.removeElectricBehaviour();
                    }
                    be.collectedBEs.forEach(other -> {
                        other.mainBE = this;
                        this.collectedBEs.add((WindingBlockEntity)other);
                    });
                    be.collectedBEs = null;
                    be.mainBE = this;
                    if (be.electricBehaviour != null) {
                        be.electricBehaviour.remove();
                        be.electricBehaviour = null;
                        be.removeBehaviour(ElectricBehaviour.TYPE);
                        be.coilWire = null;
                    }
                }
                if (!this.f_58857_.f_46443_ || this.isVirtual()) {
                    this.checkParallelPosition((BlockPos)pos1, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)parallelCheckAxis), false);
                    this.checkParallelPosition((BlockPos)pos1, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)parallelCheckAxis), false);
                }
            });
        } else {
            Optional<WindingBlockEntity> opt = block.getMainBlockEntity(this.f_58857_, this.f_58858_);
            if (opt.isEmpty()) {
                this.f_58857_.m_46961_(this.f_58858_, false);
                return;
            }
            this.mainBE = opt.get();
            if (this.mainBE.collectedBEs != null && this.mainBE.collectedBEs.add(this)) {
                this.mainBE.electricBehaviour.breakConnections();
                this.mainBE.calculateElectricalParameters();
                this.mainBE.safeRebuildParallels();
            }
        }
    }

    public void makeMain() {
        assert (this.f_58857_ != null);
        if (this.mainBE == null || this.mainBE == this) {
            return;
        }
        this.collectedBEs = this.mainBE.collectedBEs;
        this.collectedBEs.remove(this.mainBE);
        this.collectedBEs.forEach(be -> {
            be.mainBE = this;
        });
        this.calculateElectricalParameters();
        if (!this.f_58857_.f_46443_ || this.isVirtual()) {
            this.safeRebuildParallels();
        }
    }

    private void addParallel(WindingBlockEntity otherMain) {
        assert (this.f_58857_ != null);
        assert (this.isMain()) : "Only main block entities can keep track of parallel windings";
        assert (otherMain.isMain()) : "Parallel block entities must be the main entities of their windings";
        assert (!this.f_58857_.f_46443_ || this.isVirtual()) : "Parallel block entity collection can only occur on server";
        if (otherMain == this) {
            return;
        }
        if (this.ownerPosition != null) {
            Optional ownerWinding = this.f_58857_.m_141902_(this.ownerPosition, (BlockEntityType)ModdedBlockEntities.WINDING.get());
            ownerWinding.ifPresentOrElse(owner -> owner.addParallel(otherMain), () -> {
                this.ownerPosition = null;
                this.calculateElectricalParameters();
            });
        }
        if (this.ownerPosition == null) {
            if (this.parallelPositions == null) {
                this.parallelPositions = new HashSet<BlockPos>();
            }
            if (!this.parallelPositions.add(otherMain.m_58899_())) {
                return;
            }
            if (otherMain.parallelPositions != null) {
                otherMain.parallelPositions.forEach(otherPos -> {
                    Optional be = this.f_58857_.m_141902_(otherPos, (BlockEntityType)ModdedBlockEntities.WINDING.get());
                    be.ifPresent(winding -> {
                        winding.ownerPosition = this.f_58858_;
                        this.parallelPositions.add((BlockPos)otherPos);
                    });
                });
                otherMain.parallelPositions = null;
            } else if (otherMain.ownerPosition != null) {
                Optional be = this.f_58857_.m_141902_(otherMain.ownerPosition, (BlockEntityType)ModdedBlockEntities.WINDING.get());
                be.ifPresent(this::addParallel);
            }
            otherMain.clearScheduledChange();
            otherMain.ownerPosition = this.f_58858_;
            otherMain.removeElectricBehaviour();
            otherMain.sendData();
            this.sendData();
        }
    }

    public void initialize() {
        assert (this.f_58857_ != null);
        if (this.collectedBEs == null) {
            this.collectWindingParts();
        }
        if (this.parallelPositions != null) {
            this.parallelPositions.forEach(pos -> this.f_58857_.m_141902_(pos, (BlockEntityType)ModdedBlockEntities.WINDING.get()).ifPresent(WindingBlockEntity::rewire));
        }
        if (this.isMain() && this.ownerPosition == null) {
            this.calculateElectricalParameters();
        }
        super.initialize();
    }

    public int getCoilCount() {
        if (this.collectedBEs == null) {
            this.collectWindingParts();
        }
        return this.collectedBEs.size();
    }

    private void clearScheduledChange() {
        this.rebuildParallels = false;
        if (this.collectedBEs == null) {
            return;
        }
        for (WindingBlockEntity be : this.collectedBEs) {
            be.rebuildParallels = false;
        }
    }

    private void calculateElectricalParameters() {
        assert (this.f_58857_ != null);
        this.totalCoilCount = this.getCoilCount();
        if (this.ownerPosition != null && !this.ownerPosition.equals((Object)this.f_58858_)) {
            this.f_58857_.m_141902_(this.ownerPosition, (BlockEntityType)ModdedBlockEntities.WINDING.get()).ifPresent(WindingBlockEntity::calculateElectricalParameters);
            return;
        }
        this.resistance = (float)this.totalCoilCount * this.resistance();
        if (this.parallelPositions != null) {
            Iterator<BlockPos> iter = this.parallelPositions.iterator();
            while (iter.hasNext()) {
                BlockPos windingPos = iter.next();
                Optional be = this.f_58857_.m_141902_(windingPos, (BlockEntityType)ModdedBlockEntities.WINDING.get());
                if (be.isPresent()) {
                    WindingBlockEntity winding = (WindingBlockEntity)be.get();
                    this.totalCoilCount += winding.getCoilCount();
                    this.resistance += (float)winding.getCoilCount() * winding.resistance();
                    continue;
                }
                iter.remove();
            }
        }
        if (this.coilWire == null) {
            this.addElectricBehaviour();
        } else {
            this.coilWire.setLR(this.resistance * 0.01f, this.resistance);
        }
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket) {
            this.ownerPosition = null;
            this.parallelPositions = null;
            if (this.isMain()) {
                if (tag.m_128441_("Owner")) {
                    int[] owner = tag.m_128465_("Owner");
                    this.ownerPosition = new BlockPos(owner[0], owner[1], owner[2]);
                    this.removeElectricBehaviour();
                } else if (this.mainBE != null) {
                    this.calculateElectricalParameters();
                }
                if (tag.m_128441_("Parallel")) {
                    int[] data = tag.m_128465_("Parallel");
                    this.parallelPositions = new HashSet<BlockPos>();
                    for (int i = 0; i < data.length; i += 3) {
                        BlockPos pos = new BlockPos(data[i], data[i + 1], data[i + 2]);
                        this.parallelPositions.add(pos);
                    }
                    if (this.mainBE != null) {
                        this.calculateElectricalParameters();
                    }
                }
            }
        }
        float current = tag.m_128457_("Current");
        if (this.coilWire != null) {
            this.coilWire.valueChange(current, this.coilWire.current(), 5);
            this.coilWire.setCurrent(current);
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.coilWire != null) {
            tag.m_128350_("Current", this.coilWire.current());
        }
        if (clientPacket && this.isMain()) {
            if (this.ownerPosition != null) {
                tag.m_128385_("Owner", new int[]{this.ownerPosition.m_123341_(), this.ownerPosition.m_123342_(), this.ownerPosition.m_123343_()});
            }
            if (this.parallelPositions != null) {
                List data = this.parallelPositions.stream().flatMap(pos -> Stream.of(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).toList();
                tag.m_128408_("Parallel", data);
            }
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        if (this.ownerPosition == null) {
            builder.setTerminalCount(2);
            float R = Math.max(this.resistance, this.resistance());
            this.coilWire = new LRSeriesWire(R * 0.01f, R, builder.terminalNode(0), builder.terminalNode(1));
            builder.add(this.coilWire);
        }
    }

    private void rebuildParallels() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (this.ownerPosition != null) {
            PowerGrid.LOGGER.info("Non-owner winding is rebuilding parallels");
        }
        this.dissolveParallels();
        WindingBlock block = (WindingBlock)this.m_58900_().m_60734_();
        Direction.Axis parallelCheckAxis = block.getParallelCheckAxis(this.m_58900_());
        block.walk((LevelAccessor)this.f_58857_, this.f_58858_, (pos1, state) -> {
            this.checkParallelPosition((BlockPos)pos1, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)parallelCheckAxis), true);
            this.checkParallelPosition((BlockPos)pos1, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)parallelCheckAxis), true);
        });
        if (this.parallelPositions != null) {
            HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
            checkedPositions.add(this.f_58858_);
            boolean shouldContinue = true;
            while (shouldContinue) {
                shouldContinue = false;
                List<BlockPos> checkPositions = List.copyOf(this.parallelPositions);
                for (BlockPos position : checkPositions) {
                    if (!checkedPositions.add(position)) continue;
                    block.walk((LevelAccessor)this.f_58857_, position, (pos1, state) -> {
                        Direction.Axis newCheckAxis = block.getParallelCheckAxis((BlockState)state);
                        this.checkParallelPosition((BlockPos)pos1, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)newCheckAxis), true);
                        this.checkParallelPosition((BlockPos)pos1, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)newCheckAxis), true);
                    });
                    shouldContinue = true;
                }
            }
        }
        this.calculateElectricalParameters();
        this.sendData();
    }

    private void dissolveParallels() {
        assert (this.f_58857_ != null);
        if (this.parallelPositions != null) {
            for (BlockPos parallelPos : this.parallelPositions) {
                Optional be = this.f_58857_.m_141902_(parallelPos, (BlockEntityType)ModdedBlockEntities.WINDING.get());
                be.ifPresent(winding -> {
                    winding.ownerPosition = null;
                    winding.calculateElectricalParameters();
                });
            }
            this.parallelPositions = null;
        }
        if (this.ownerPosition != null) {
            PowerGrid.LOGGER.info("Non-owner winding is dissolving parallels");
        }
        this.ownerPosition = null;
        this.calculateElectricalParameters();
    }

    private void moveParallelOwnership(WindingBlockEntity newOwner, boolean withoutThis) {
        assert (this.f_58857_ != null);
        if (newOwner == this) {
            return;
        }
        assert (this.ownerPosition == null && (this.f_58858_.equals((Object)newOwner.ownerPosition) || newOwner.ownerPosition == null));
        this.parallelPositions.remove(newOwner.f_58858_);
        if (!withoutThis) {
            this.parallelPositions.add(this.f_58858_);
        }
        newOwner.parallelPositions = this.parallelPositions;
        this.parallelPositions = null;
        if (!withoutThis) {
            this.ownerPosition = newOwner.f_58858_;
        }
        this.removeElectricBehaviour();
        newOwner.ownerPosition = null;
        newOwner.parallelPositions.forEach(bePos -> this.f_58857_.m_141902_(bePos, (BlockEntityType)ModdedBlockEntities.WINDING.get()).ifPresent(be -> {
            be.ownerPosition = newOwner.f_58858_;
        }));
        newOwner.calculateElectricalParameters();
    }

    public void onNeighborChanged(BlockPos neighborPos) {
        this.rebuildParallels = true;
    }

    private void safeRebuildParallels() {
        assert (this.f_58857_ != null);
        if (this.mainBE == null) {
            return;
        }
        if (this.mainBE.parallelPositions != null) {
            this.mainBE.rebuildParallels();
        } else if (this.mainBE.ownerPosition != null) {
            Optional be = this.f_58857_.m_141902_(this.mainBE.ownerPosition, (BlockEntityType)ModdedBlockEntities.WINDING.get());
            be.ifPresentOrElse(WindingBlockEntity::rebuildParallels, this.mainBE::rebuildParallels);
        } else {
            this.mainBE.rebuildParallels();
        }
    }

    private WindingBlockEntity getSimElementHolder() {
        assert (this.f_58857_ != null);
        if (this.mainBE == null) {
            return null;
        }
        if (this.mainBE.ownerPosition != null) {
            if (this.mainBE.ownerPosition.equals((Object)this.f_58858_)) {
                return null;
            }
            Optional opt = this.f_58857_.m_141902_(this.mainBE.ownerPosition, (BlockEntityType)ModdedBlockEntities.WINDING.get());
            if (opt.isPresent()) {
                WindingBlockEntity be = (WindingBlockEntity)opt.get();
                return be.getSimElementHolder();
            }
        }
        if (this.mainBE.coilWire == null || this.mainBE.totalCoilCount == 0) {
            return null;
        }
        return this.mainBE;
    }

    public float windingCurrent() {
        WindingBlockEntity be = this.getSimElementHolder();
        if (be == null || !be.coilWire.isConverged()) {
            return 0.0f;
        }
        return be.coilWire.current();
    }

    @Override
    public void remove() {
        assert (this.f_58857_ != null);
        if (this.mainBE != null) {
            for (TransmissionLinePart part : this.mainBE.wires()) {
                if (part.owner != null) {
                    part.owner.m_6074_();
                    continue;
                }
                part.remove();
            }
            this.mainBE.electricBehaviour.breakConnections();
        }
        if (this.mainBE == this) {
            if (this.parallelPositions != null) {
                WindingBlockEntity newOwner = null;
                Iterator<BlockPos> iter = this.parallelPositions.iterator();
                while (newOwner == null && iter.hasNext()) {
                    BlockPos bePos = iter.next();
                    Optional be = this.f_58857_.m_141902_(bePos, (BlockEntityType)ModdedBlockEntities.WINDING.get());
                    if (!be.isPresent()) continue;
                    newOwner = (WindingBlockEntity)be.get();
                }
                if (newOwner != null) {
                    this.moveParallelOwnership(newOwner, true);
                }
            } else if (this.ownerPosition != null) {
                Optional be = this.f_58857_.m_141902_(this.ownerPosition, (BlockEntityType)ModdedBlockEntities.WINDING.get());
                be.ifPresentOrElse(WindingBlockEntity::rebuildParallels, this::rebuildParallels);
            }
        } else if (this.mainBE != null) {
            this.mainBE.collectedBEs.remove(this);
            this.mainBE.calculateElectricalParameters();
            this.mainBE.safeRebuildParallels();
        }
        super.remove();
    }

    public void tick() {
        if (this.rebuildParallels) {
            this.safeRebuildParallels();
            this.rebuildParallels = false;
        }
        float current = this.windingCurrent();
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyTickPower(current * current * this.resistance());
        }
        this.m_6596_();
        super.tick();
    }
}

