/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntityEndpoint;
import org.patryk3211.powergrid.electricity.wire.DeferredJunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.network.SimplePacket;

public class BlockWireAttachC2SPacket
implements SimplePacket {
    public final int entityId;
    public final int index;
    public final int gridPoint;

    public BlockWireAttachC2SPacket(BlockWireEntity entity, int index, int gridPoint) {
        this.entityId = entity.m_19879_();
        this.index = index;
        this.gridPoint = gridPoint;
    }

    public BlockWireAttachC2SPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.index = buf.readInt();
        this.gridPoint = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.index);
        buf.writeInt(this.gridPoint);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            InteractionResultHolder<BlockWireEntity> result;
            IWireEndpoint endpoint;
            Player player = ctx.getPlayer();
            Entity entity = player.m_9236_().m_6815_(this.entityId);
            if (!(entity instanceof BlockWireEntity)) {
                PowerGrid.LOGGER.error("Received block wire attach packet with invalid entity");
                return;
            }
            BlockWireEntity wire = (BlockWireEntity)entity;
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof WireItem)) {
                PowerGrid.LOGGER.error("Received wire attach packet for player whose not holding a wire");
                return;
            }
            if (this.index < 0 || this.index >= wire.segments.size()) {
                PowerGrid.LOGGER.error("Received wire segment index out of bounds");
                return;
            }
            BlockWireEntity.Point segment = wire.segments.get(this.index);
            int gridLength = segment.gridLength;
            if (this.gridPoint < 0 || this.gridPoint > gridLength) {
                PowerGrid.LOGGER.error("Received wire segment length out of bounds");
                return;
            }
            IWireEndpoint existingEndpoint = WireEndpointType.deserialize(stack.m_41783_());
            if (this.gridPoint <= 1 && this.index == 0) {
                if (wire.getEndpoint1() == null) {
                    wire = wire.flip();
                    endpoint = new BlockWireEntityEndpoint(wire, true);
                } else {
                    endpoint = wire.getEndpoint1();
                }
            } else {
                endpoint = this.gridPoint >= segment.gridLength - 1 && this.index == wire.segments.size() - 1 ? (wire.getEndpoint2() == null ? new BlockWireEntityEndpoint(wire, true) : wire.getEndpoint2()) : new DeferredJunctionWireEndpoint(wire, this.index, this.gridPoint);
            }
            if (endpoint != null && existingEndpoint == null) {
                stack.m_41751_(endpoint.serialize());
            } else if (endpoint != null && (result = WireItem.connect(player.m_9236_(), stack, player, existingEndpoint, endpoint)).m_19089_().m_19077_()) {
                stack.m_41751_(null);
            }
        });
    }
}

