/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class EntityDataS2CPacket
implements SimplePacket {
    private static final Map<Integer, CompoundTag> DEFERRED_DATA = new HashMap<Integer, CompoundTag>();
    public final int entityId;
    public final CompoundTag data;

    public EntityDataS2CPacket(Entity entity, CompoundTag data) {
        this.entityId = entity.m_19879_();
        this.data = data;
    }

    public EntityDataS2CPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.data = buffer.m_130260_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130079_(this.data);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            Level world = ClientSideAccess.world();
            Entity entity = world.m_6815_(this.entityId);
            if (entity == null) {
                DEFERRED_DATA.put(this.entityId, this.data);
                return;
            }
            if (entity instanceof IConsumer) {
                IConsumer consumer = (IConsumer)entity;
                consumer.onEntityDataPacket(this.data);
            }
        });
    }

    public static void clientEntityAdded(Entity entity) {
        CompoundTag tag = DEFERRED_DATA.remove(entity.m_19879_());
        if (tag == null) {
            return;
        }
        if (entity instanceof IConsumer) {
            IConsumer consumer = (IConsumer)entity;
            consumer.onEntityDataPacket(tag);
        }
    }

    public static interface IConsumer {
        public void onEntityDataPacket(CompoundTag var1);
    }
}

