/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.equipment.thunder.LightningRodMovementBehaviour;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class LightningSyncS2CPacket
implements SimplePacket {
    private final int entityId;

    public LightningSyncS2CPacket(MovementContext context) {
        this.entityId = context.contraption.entity.m_19879_();
    }

    public LightningSyncS2CPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            Level world = ClientSideAccess.world();
            Entity patt0$temp = world.m_6815_(this.entityId);
            if (patt0$temp instanceof AbstractContraptionEntity) {
                AbstractContraptionEntity entity = (AbstractContraptionEntity)patt0$temp;
                entity.getContraption().forEachActor(world, (behaviour, movementContext) -> {
                    if (!(behaviour instanceof LightningRodMovementBehaviour)) {
                        return;
                    }
                    LightningRodMovementBehaviour lightningBehaviour = (LightningRodMovementBehaviour)behaviour;
                    movementContext.data.m_128350_("Charge", 0.0f);
                    if (movementContext.temporaryData == movementContext) {
                        lightningBehaviour.fireClient((MovementContext)movementContext);
                    }
                });
            }
        });
    }
}

