/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.info.TerminalHandler;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlockEntity;
import org.patryk3211.powergrid.electricity.wire.WirePreview;
import org.patryk3211.powergrid.equipment.multimeter.MultimeterItemRenderer;
import org.patryk3211.powergrid.equipment.thermometer.ThermometerItemRenderer;
import org.patryk3211.powergrid.mixin.client.BlueprintOverlayRendererAccessor;
import org.patryk3211.powergrid.utility.Lang;

@OnlyIn(value=Dist.CLIENT)
public class PlacementOverlay {
    private static final List<IOverlayTextProvider> overlayProviders = new ArrayList<IOverlayTextProvider>();
    private static Component prevText = null;
    private static int overlayTicks = -1;
    public static boolean thisActivation = false;

    public static void init() {
        overlayProviders.add(PlacementOverlay::getTransformerText);
        overlayProviders.add(MultimeterItemRenderer::multimeterOverlayText);
        overlayProviders.add(TerminalHandler::overlayText);
        overlayProviders.add(WirePreview::distanceOverlay);
        overlayProviders.add(ThermometerItemRenderer::overlayText);
    }

    public static void setItemRequirement(Item item, int count, boolean hasItems) {
        if (!BlueprintOverlayRendererAccessor.getActive() || !thisActivation) {
            BlueprintOverlayRendererAccessor.setActive(true);
            BlueprintOverlayRendererAccessor.setEmpty(false);
            BlueprintOverlayRendererAccessor.setNoOutput(true);
            thisActivation = true;
            List<Pair<ItemStack, Boolean>> ingredients = BlueprintOverlayRendererAccessor.getIngredients();
            ingredients.clear();
            for (int wires = count; wires > 0; wires -= 64) {
                ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)new ItemStack((ItemLike)item, Math.min(64, wires)), (Object)hasItems));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(Gui gui, GuiGraphics graphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91066_.f_92062_ && mc.f_91072_.m_105295_() != GameType.SPECTATOR) {
            IOverlayTextProvider provider;
            Component text = null;
            LocalPlayer player = mc.f_91074_;
            Iterator<IOverlayTextProvider> iterator = overlayProviders.iterator();
            while (iterator.hasNext() && (text = (provider = iterator.next()).get((Player)player)) == null) {
            }
            if (text != null) {
                if (overlayTicks < 10) {
                    ++overlayTicks;
                }
                prevText = text;
            } else if (prevText != null) {
                text = prevText;
                if (--overlayTicks <= 0) {
                    overlayTicks = 0;
                    prevText = null;
                }
            }
            if (text != null) {
                Window window = mc.m_91268_();
                int x = (window.m_85445_() - gui.m_93082_().m_92852_((FormattedText)text)) / 2;
                int y = window.m_85446_() - 61;
                Color color = new Color(4905802);
                float alpha = (float)Mth.m_14045_((int)overlayTicks, (int)0, (int)10) / 10.0f;
                float[] state = Arrays.copyOf(RenderSystem.getShaderColor(), 4);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                graphics.m_280614_(gui.m_93082_(), text, x, y, color.getRGB(), true);
                RenderSystem.setShaderColor((float)state[0], (float)state[1], (float)state[2], (float)state[3]);
            }
        }
    }

    public static Component getTransformerText(Player player) {
        int[] posArray;
        BlockPos initiatorPos;
        ItemStack wireStack = WirePreview.getUsedWireStack(player);
        if (wireStack == null) {
            return null;
        }
        CompoundTag tag = wireStack.m_41783_();
        assert (tag != null);
        if (!tag.m_128441_("Turns") || !tag.m_128441_("Initiator")) {
            return null;
        }
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(initiatorPos = new BlockPos((posArray = tag.m_128465_("Initiator"))[0], posArray[1], posArray[2]));
        Block block = state.m_60734_();
        if (!(block instanceof TransformerBlock)) {
            return null;
        }
        TransformerBlock transformerBlock = (TransformerBlock)block;
        Optional<TransformerBlockEntity> transformerOpt = transformerBlock.getBlockEntity(world, initiatorPos, state);
        if (transformerOpt.isEmpty()) {
            return null;
        }
        TransformerBlockEntity transformer = transformerOpt.get();
        int turns = tag.m_128451_("Turns");
        if (!transformer.hasPrimary()) {
            return Lang.translateDirect("message.coil_winding_primary", Lang.number(turns).style(ChatFormatting.WHITE).component());
        }
        int primaryTurns = transformer.getPrimary().getTurns();
        int largestCommonDenominator = 1;
        for (int i = 2; i <= Math.max(primaryTurns, turns); ++i) {
            if (turns % i != 0 || primaryTurns % i != 0) continue;
            largestCommonDenominator = i;
        }
        LangBuilder n1 = Lang.number(primaryTurns / largestCommonDenominator);
        LangBuilder n2 = Lang.number(turns / largestCommonDenominator);
        LangBuilder ratio = n1.add(Component.m_130674_((String)":")).add(n2);
        return Lang.translateDirect("message.coil_winding_secondary", Lang.number(turns).style(ChatFormatting.WHITE).component(), ratio.style(ChatFormatting.WHITE).component());
    }

    public static interface IOverlayTextProvider {
        @Nullable
        public Component get(Player var1);
    }
}

