/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid;

import com.mojang.blaze3d.platform.Window;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.collections.ModdedRenderLayers;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.info.TerminalHandler;
import org.patryk3211.powergrid.electricity.transformer.TransformerWindingScreen;
import org.patryk3211.powergrid.electricity.wire.ClientWireInteractions;
import org.patryk3211.powergrid.equipment.multimeter.MultimeterItemRenderer;
import org.patryk3211.powergrid.equipment.thermometer.ThermometerItemRenderer;
import org.patryk3211.powergrid.equipment.zapper.ElectroZapperRenderHandler;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingPreview;
import org.patryk3211.powergrid.ponder.PowerGridPonderPlugin;
import org.patryk3211.powergrid.utility.CustomValueSettingsScreen;
import org.patryk3211.powergrid.utility.PlacementOverlay;

public class PowerGridClient {
    public static final ElectroZapperRenderHandler ELECTRO_ZAPPER_RENDER_HANDLER = new ElectroZapperRenderHandler();

    public static void initClient() {
        ModdedPartialModels.register();
        ModdedRenderLayers.register();
        PowerGridClient.registerOverlays();
        PlacementOverlay.init();
        PowerGridClient.registerArchitecturyEvents();
        PonderIndex.addPlugin((PonderPlugin)new PowerGridPonderPlugin());
    }

    public static void registerArchitecturyEvents() {
        ClientTickEvent.CLIENT_LEVEL_PRE.register(GlobalElectricNetworks::tick);
        ClientTickEvent.CLIENT_LEVEL_POST.register(TerminalHandler::tick);
        ClientTickEvent.CLIENT_POST.register(PowerGridClient::clientTick);
    }

    private static void clientTick(Minecraft client) {
        if (client.f_91073_ == null || client.f_91074_ == null) {
            return;
        }
        ELECTRO_ZAPPER_RENDER_HANDLER.tick();
        CustomValueSettingsScreen.clientTick();
        WindingPreview.tick();
        TransformerWindingScreen.clientTick();
        ClientWireInteractions.clientTick();
        ThermometerItemRenderer.clientTick();
        MultimeterItemRenderer.clientTick((Level)client.f_91073_, (Player)client.f_91074_);
    }

    public static void registerOverlays() {
        ClientGuiEvent.RENDER_HUD.register((graphics, partialTicks) -> {
            Window window = Minecraft.m_91087_().m_91268_();
            PlacementOverlay.renderOverlay(Minecraft.m_91087_().f_91065_, graphics);
        });
    }
}

