/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.circuitboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.thermal.ThermalBuilder;
import org.patryk3211.powergrid.circuits.thermal.ThermalUnit;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;

public class BakedCircuit {
    public final List<OwnedFloatingNode> externalNodes = new ArrayList<OwnedFloatingNode>();
    public final List<INode> internalNodes = new ArrayList<INode>();
    public final List<AbstractElectricWire> wires = new ArrayList<AbstractElectricWire>();
    public final List<TerminalBoundingBox> terminals = new ArrayList<TerminalBoundingBox>();
    public final List<ThermalUnit> thermalUnits = new ArrayList<ThermalUnit>();
    public final List<PlacedComponent> tickedComponents = new ArrayList<PlacedComponent>();
    private final Map<PlacedComponent, Function<Integer, FloatingNode>> padNodeProviderMap = new HashMap<PlacedComponent, Function<Integer, FloatingNode>>();
    private boolean isDamaged = false;
    private final CircuitBoardBlockEntity be;
    private boolean firstTick = true;

    protected BakedCircuit(CircuitBoardBlockEntity be) {
        this.be = be;
    }

    public FloatingNode getNode(CircuitSchematic.Node node) {
        return this.padNodeProviderMap.get(node.placed()).apply(node.pad());
    }

    private static void makePadNodes(BakedCircuit result, CircuitSchematic schematic, CircuitBoardBlockEntity be) {
        BlockPos pos = be.m_58899_();
        Vec3 offset = Vec3.m_82528_((Vec3i)pos);
        for (PlacedComponent placed : schematic.components()) {
            HashSet<Integer> nodeIndexSet = new HashSet<Integer>();
            for (ComponentFootprint.PadData pad : placed.footprint().getPads().values()) {
                if (pad.nodeIndex() < 0) continue;
                nodeIndexSet.add(pad.nodeIndex());
            }
            boolean external = placed.component.emitExternalTerminals();
            int nodeOffset = external ? result.externalNodes.size() : result.internalNodes.size();
            for (int i = 0; i < nodeIndexSet.size(); ++i) {
                FloatingNode node;
                if (external) {
                    node = new OwnedFloatingNode(new BlockWireEndpoint(pos, nodeOffset + i));
                    result.externalNodes.add((OwnedFloatingNode)node);
                    continue;
                }
                node = new FloatingNode();
                result.internalNodes.add(node);
            }
            Function<Integer, FloatingNode> provider = external ? index -> result.externalNodes.get(index + nodeOffset) : index -> (FloatingNode)result.internalNodes.get(index + nodeOffset);
            result.padNodeProviderMap.put(placed, provider);
            ComponentCircuitBuilder builder = new ComponentCircuitBuilder(pos, provider, result.internalNodes, result.wires);
            placed.nodes.clear();
            placed.wires.clear();
            MutableInt thermalIndex = new MutableInt(0);
            ArrayList thermalBuilders = new ArrayList();
            ThermalBuilder.IEmitter thermalEmitter = () -> {
                ThermalBuilder thermalBuilder = new ThermalBuilder(placed.getUUID(), thermalIndex.getAndIncrement());
                thermalBuilders.add(thermalBuilder);
                return thermalBuilder;
            };
            placed.destroyed = false;
            placed.component.bake(placed, builder, thermalEmitter);
            ComponentFootprint footprint = placed.footprint();
            Vec3 localPos = new Vec3((double)(((float)placed.x + (float)footprint.getWidth() * 0.5f) / 16.0f), 0.125, (double)(((float)placed.y + (float)footprint.getHeight() * 0.5f) / 16.0f)).m_82492_(0.5, 0.0, 0.5).m_82496_((float)Math.PI * (float)CircuitBoardBlock.getAngleX(be.m_58900_()) / 180.0f).m_82524_((float)Math.PI * (float)CircuitBoardBlock.getAngleY(be.m_58900_()) / 180.0f).m_82520_(0.5, 0.0, 0.5).m_82549_(offset);
            thermalBuilders.stream().map(b -> b.build().withPosition(localPos)).forEach(result.thermalUnits::add);
            result.tickedComponents.add(placed);
            if (!external) continue;
            List<TerminalBoundingBox> bbs = placed.component.terminals(placed);
            bbs.stream().map(bb -> bb.offset((float)placed.x / 16.0f, 0.125, (float)placed.y / 16.0f)).forEach(result.terminals::add);
        }
    }

    public static BakedCircuit from(CircuitSchematic schematic, CircuitBoardBlockEntity be) {
        BakedCircuit result = new BakedCircuit(be);
        BakedCircuit.makePadNodes(result, schematic, be);
        Collection<Collection<CircuitSchematic.Node>> bundles = schematic.findNodeBundles();
        for (Collection<CircuitSchematic.Node> bundle : bundles) {
            if (bundle.size() <= 1) continue;
            if (bundle.size() == 2) {
                Iterator<CircuitSchematic.Node> iter = bundle.iterator();
                CircuitSchematic.Node node1 = iter.next();
                CircuitSchematic.Node node2 = iter.next();
                float R = node1.getPadResistance() + node2.getPadResistance();
                ElectricWire wire = new ElectricWire(R, result.getNode(node1), result.getNode(node2));
                result.wires.add(wire);
                continue;
            }
            FloatingNode junctionNode = new FloatingNode();
            result.internalNodes.add(junctionNode);
            for (CircuitSchematic.Node node : bundle) {
                ElectricWire wire = new ElectricWire(node.getPadResistance(), result.getNode(node), junctionNode);
                result.wires.add(wire);
            }
        }
        return result;
    }

    public void write(CompoundTag tag) {
        CompoundTag thermalTag = new CompoundTag();
        for (ThermalUnit unit : this.thermalUnits) {
            unit.write(thermalTag);
        }
        tag.m_128365_("Thermal", (Tag)thermalTag);
    }

    public void read(CompoundTag tag) {
        if (tag.m_128441_("Thermal")) {
            CompoundTag thermalTag = tag.m_128469_("Thermal");
            for (ThermalUnit unit : this.thermalUnits) {
                unit.read(thermalTag);
                if (!unit.hasOverheated()) continue;
                for (PlacedComponent placed : this.padNodeProviderMap.keySet()) {
                    if (!placed.uuid.equals(unit.getId())) continue;
                    placed.destroyed = true;
                    Component.modelChanged(this.be.m_58899_());
                }
            }
        }
        this.isDamaged = false;
    }

    public boolean isDamaged() {
        if (this.isDamaged) {
            return true;
        }
        for (ThermalUnit unit : this.thermalUnits) {
            if (!unit.hasOverheated()) continue;
            this.isDamaged = true;
            break;
        }
        return this.isDamaged;
    }

    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            return;
        }
        boolean client = this.be.m_58904_().f_46443_;
        if (ThermalBehaviour.shouldOverheat()) {
            for (ThermalUnit unit : this.thermalUnits) {
                boolean overheated = unit.hasOverheated();
                unit.tick(this.be.coolingFactorMultiplier);
                if (!client) continue;
                Level world = this.be.m_58904_();
                RandomSource random = world.f_46441_;
                Vec3 pos = unit.getPosition();
                float x = (float)pos.m_7096_() + (random.m_188501_() - 0.5f) * 1.0f / 16.0f;
                float y = (float)pos.m_7098_() + (random.m_188501_() - 0.5f) * 1.0f / 16.0f;
                float z = (float)pos.m_7094_() + (random.m_188501_() - 0.5f) * 1.0f / 16.0f;
                if (!unit.hasOverheated() && unit.getTemperature() >= unit.getOverheatTemperature() - 50.0f) {
                    float chance = (unit.getTemperature() - unit.getOverheatTemperature() + 100.0f) / 100.0f;
                    if (!(random.m_188501_() < chance)) continue;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x, (double)y, (double)z, 0.0, (double)0.05f, 0.0);
                    continue;
                }
                if (overheated || !unit.hasOverheated()) continue;
                SparkParticleData.explodeParticles(world, x, y, z, Direction.UP, 10);
                ModdedSoundEvents.COMPONENT_EXPLODE.playAt(world, pos, 1.0f, random.m_188501_() * 0.1f + 0.9f, true);
                for (PlacedComponent placed2 : this.padNodeProviderMap.keySet()) {
                    if (!placed2.uuid.equals(unit.getId())) continue;
                    placed2.destroyed = true;
                    Component.modelChanged(this.be.m_58899_());
                }
            }
        }
        this.tickedComponents.removeIf(placed -> !placed.tick());
    }
}

