/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.circuitboard;

import com.simibubi.create.foundation.block.IBE;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.IInteractableComponent;
import org.patryk3211.powergrid.circuits.components.IRedstoneComponent;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.editor.CircuitBoardEditMenu;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitBoardBlock
extends ElectricBlock
implements IBE<CircuitBoardBlockEntity> {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)2);
    private static final VoxelShape SHAPE_PLATE = CircuitBoardBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public CircuitBoardBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, ROTATION});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction face = ctx.m_43719_();
        if (face.m_122434_() == Direction.Axis.Y) {
            Direction player = ctx.m_43723_() == null || !ctx.m_43723_().m_6144_() ? ctx.m_8125_() : ctx.m_8125_().m_122424_();
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)player)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(face == Direction.UP ? 0 : 2));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(1))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)face.m_122424_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.withBlockEntityDo((BlockGetter)world, pos, be -> {
            be.setSchematic(CircuitSchematic.fromStack(stack));
            be.setAdditionalData(stack.m_41783_());
        });
        super.m_6402_(world, pos, state, placer, stack);
    }

    private static VoxelShape rotate(VoxelShape shapeIn, float x, float y) {
        if (y == 0.0f && x == 0.0f) {
            return shapeIn;
        }
        MutableObject result = new MutableObject((Object)Shapes.m_83040_());
        Vec3 center = new Vec3(8.0, 8.0, 8.0);
        shapeIn.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            Vec3 v1 = new Vec3(x1, y1, z1).m_82490_(16.0).m_82546_(center);
            Vec3 v2 = new Vec3(x2, y2, z2).m_82490_(16.0).m_82546_(center);
            v1 = VecHelper.rotate((Vec3)v1, (double)x, (Direction.Axis)Direction.Axis.X);
            v1 = VecHelper.rotate((Vec3)v1, (double)y, (Direction.Axis)Direction.Axis.Y).m_82549_(center);
            v2 = VecHelper.rotate((Vec3)v2, (double)x, (Direction.Axis)Direction.Axis.X);
            v2 = VecHelper.rotate((Vec3)v2, (double)y, (Direction.Axis)Direction.Axis.Y).m_82549_(center);
            VoxelShape rotated = CircuitBoardBlock.m_49796_((double)Math.min(v1.f_82479_, v2.f_82479_), (double)Math.min(v1.f_82480_, v2.f_82480_), (double)Math.min(v1.f_82481_, v2.f_82481_), (double)Math.max(v1.f_82479_, v2.f_82479_), (double)Math.max(v1.f_82480_, v2.f_82480_), (double)Math.max(v1.f_82481_, v2.f_82481_));
            result.setValue((Object)Shapes.m_83110_((VoxelShape)((VoxelShape)result.getValue()), (VoxelShape)rotated));
        });
        return (VoxelShape)result.getValue();
    }

    public static int getAngleX(BlockState state) {
        if (!(state.m_60734_() instanceof CircuitBoardBlock)) {
            return 0;
        }
        return (Integer)state.m_61143_((Property)ROTATION) * 90;
    }

    public static int getAngleY(BlockState state) {
        if (!(state.m_60734_() instanceof CircuitBoardBlock)) {
            return 0;
        }
        int angle = switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> -90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 90;
            default -> throw new IllegalStateException();
        };
        if ((Integer)state.m_61143_((Property)ROTATION) == 2) {
            angle -= 180;
        }
        return angle;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int x = CircuitBoardBlock.getAngleX(state);
        int y = CircuitBoardBlock.getAngleY(state);
        VoxelShape[] shape = new VoxelShape[]{CircuitBoardBlock.rotate(SHAPE_PLATE, x, y)};
        this.withBlockEntityDo(world, pos, be -> {
            VoxelShape shapeCopy = shape[0];
            for (int i = 0; i < be.terminalCount(); ++i) {
                ITerminalPlacement terminal = be.terminal(state, i);
                shapeCopy = Shapes.m_83110_((VoxelShape)((TerminalBoundingBox)terminal).getShape(), (VoxelShape)shapeCopy);
            }
            for (PlacedComponent placed : be.getComponents(IInteractableComponent.class)) {
                IInteractableComponent dynamic = (IInteractableComponent)((Object)placed.component);
                shapeCopy = Shapes.m_83110_((VoxelShape)CircuitBoardBlock.rotate(dynamic.getShape(placed), x, y), (VoxelShape)shapeCopy);
            }
            shape[0] = shapeCopy;
        });
        return shape[0];
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(world, pos, state);
        this.withBlockEntityDo(world, pos, be -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Schematic", (Tag)be.getSchematic().serializeNbt());
            stack.m_41751_(tag);
        });
        return stack;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        MutableInt output = new MutableInt();
        this.withBlockEntityDo(world, pos, be -> {
            for (PlacedComponent placed : be.getComponents(IRedstoneComponent.class)) {
                int level;
                IRedstoneComponent redstone = (IRedstoneComponent)((Object)placed.component);
                if (!redstone.isEmitter() || placed.has(Orientation.PROPERTY) && placed.get(Orientation.PROPERTY) != CircuitBoardBlock.getOrientation(state, direction.m_122424_()) || (level = redstone.getEmittedLevel(placed)) <= output.getValue()) continue;
                output.setValue(level);
            }
        });
        return output.getValue();
    }

    @Nullable
    public static Orientation getOrientation(BlockState state, Direction side) {
        Orientation orientation;
        Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        if ((Integer)state.m_61143_((Property)ROTATION) == 1) {
            if (side == Direction.UP) {
                return Orientation.UP;
            }
            if (side == Direction.DOWN) {
                return Orientation.DOWN;
            }
            if (side == facing.m_122428_()) {
                return Orientation.LEFT;
            }
            if (side == facing.m_122427_()) {
                return Orientation.RIGHT;
            }
            return null;
        }
        if ((Integer)state.m_61143_((Property)ROTATION) == 0) {
            orientation = switch (side) {
                case Direction.NORTH -> Orientation.UP;
                case Direction.EAST -> Orientation.RIGHT;
                case Direction.SOUTH -> Orientation.DOWN;
                case Direction.WEST -> Orientation.LEFT;
                default -> null;
            };
        } else {
            switch (side) {
                case NORTH: {
                    Orientation orientation2 = Orientation.UP;
                    break;
                }
                case EAST: {
                    Orientation orientation2 = Orientation.LEFT;
                    break;
                }
                case SOUTH: {
                    Orientation orientation2 = Orientation.DOWN;
                    break;
                }
                case WEST: {
                    Orientation orientation2 = Orientation.RIGHT;
                    break;
                }
                default: {
                    Orientation orientation2 = orientation = null;
                }
            }
        }
        if (orientation == null) {
            return null;
        }
        if ((Integer)state.m_61143_((Property)ROTATION) == 0) {
            orientation = switch (facing) {
                case Direction.NORTH -> orientation;
                case Direction.SOUTH -> orientation.getOpposite();
                case Direction.EAST -> orientation.getCounterClockwise();
                case Direction.WEST -> orientation.getClockwise();
                default -> throw new IllegalStateException();
            };
        } else {
            orientation = switch (facing) {
                case Direction.NORTH -> orientation;
                case Direction.SOUTH -> orientation.getOpposite();
                case Direction.WEST -> orientation.getCounterClockwise();
                case Direction.EAST -> orientation.getClockwise();
                default -> throw new IllegalStateException();
            };
        }
        return orientation;
    }

    public static Direction getDirection(BlockState state, Orientation orientation) {
        Direction dir;
        Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        if ((Integer)state.m_61143_((Property)ROTATION) == 1) {
            if (orientation == Orientation.UP) {
                return Direction.UP;
            }
            if (orientation == Orientation.DOWN) {
                return Direction.DOWN;
            }
            if (orientation == Orientation.LEFT) {
                return facing.m_122428_();
            }
            if (orientation == Orientation.RIGHT) {
                return facing.m_122427_();
            }
            throw new IllegalStateException();
        }
        if ((Integer)state.m_61143_((Property)ROTATION) == 0) {
            dir = switch (orientation) {
                default -> throw new IncompatibleClassChangeError();
                case Orientation.UP -> Direction.NORTH;
                case Orientation.RIGHT -> Direction.EAST;
                case Orientation.DOWN -> Direction.SOUTH;
                case Orientation.LEFT -> Direction.WEST;
            };
            dir = switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
                case Direction.NORTH -> dir;
                case Direction.SOUTH -> dir.m_122424_();
                case Direction.EAST -> dir.m_122427_();
                case Direction.WEST -> dir.m_122428_();
                default -> throw new IllegalStateException();
            };
        } else {
            dir = switch (orientation) {
                default -> throw new IncompatibleClassChangeError();
                case Orientation.UP -> Direction.SOUTH;
                case Orientation.RIGHT -> Direction.EAST;
                case Orientation.DOWN -> Direction.NORTH;
                case Orientation.LEFT -> Direction.WEST;
            };
            dir = switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
                case Direction.NORTH -> dir.m_122424_();
                case Direction.SOUTH -> dir;
                case Direction.EAST -> dir.m_122428_();
                case Direction.WEST -> dir.m_122427_();
                default -> throw new IllegalStateException();
            };
        }
        return dir;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        super.m_6861_(state, world, pos, sourceBlock, sourcePos, notify);
        this.withBlockEntityDo((BlockGetter)world, pos, be -> {
            BlockPos dirVec = sourcePos.m_121996_((Vec3i)pos);
            Direction dir = Direction.m_122378_((int)dirVec.m_123341_(), (int)dirVec.m_123342_(), (int)dirVec.m_123343_());
            if (dir == null) {
                return;
            }
            int power = world.m_277185_(sourcePos, dir);
            for (PlacedComponent placed : be.getComponents(IRedstoneComponent.class)) {
                IRedstoneComponent redstone = (IRedstoneComponent)((Object)placed.component);
                if (!redstone.isReceiver()) continue;
                if (placed.has(Orientation.PROPERTY)) {
                    if (placed.get(Orientation.PROPERTY) != CircuitBoardBlock.getOrientation(state, dir)) continue;
                    redstone.receiveRedstone(placed, power);
                    continue;
                }
                redstone.receiveRedstone(placed, power);
            }
        });
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult beResult = this.onBlockEntityUse((BlockGetter)world, pos, be -> {
            Vec3 hitLocalPos = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            hitLocalPos = VecHelper.rotateCentered((Vec3)hitLocalPos, (double)(-CircuitBoardBlock.getAngleY(state)), (Direction.Axis)Direction.Axis.Y);
            hitLocalPos = VecHelper.rotateCentered((Vec3)hitLocalPos, (double)(-CircuitBoardBlock.getAngleX(state)), (Direction.Axis)Direction.Axis.X);
            Iterator<PlacedComponent> iterator = be.getComponents(IInteractableComponent.class).iterator();
            while (iterator.hasNext()) {
                PlacedComponent placed;
                IInteractableComponent dynamic = (IInteractableComponent)((Object)placed.component);
                placed = iterator.next();
                AABB outline = dynamic.getShape(placed).m_83215_().m_82400_(0.03125);
                if (!outline.m_82390_(hitLocalPos)) continue;
                return dynamic.use((CircuitBoardBlockEntity)be, placed, player);
            }
            if (player.m_7500_() && player.m_6144_()) {
                be.repairBroken();
                return InteractionResult.SUCCESS;
            }
            if (player.m_7500_() && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (player.m_21205_().m_41619_() && player.m_21206_().m_41619_()) {
                    MenuRegistry.openExtendedMenu((ServerPlayer)sp, (MenuProvider)new MenuProvider(){
                        final /* synthetic */ CircuitBoardBlockEntity val$be;
                        {
                            this.val$be = circuitBoardBlockEntity;
                        }

                        public Component m_5446_() {
                            return Component.m_237113_((String)"Circuit");
                        }

                        @Nullable
                        public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                            if (!player.m_7500_()) {
                                return null;
                            }
                            return CircuitBoardEditMenu.create(i, inventory, this.val$be);
                        }
                    }, arg_0 -> ((CircuitBoardBlockEntity)be).sendToMenu(arg_0));
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        });
        if (beResult != InteractionResult.PASS) {
            return beResult;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        CircuitSchematic schematic = CircuitSchematic.fromStack(stack);
        if (schematic != null && schematic.getName() != null) {
            tooltip.add((Component)Lang.translate("circuit_board.tooltip.schematic", new Object[0]).add(Component.m_237113_((String)schematic.getName())).style(ChatFormatting.GRAY).component());
        }
        super.m_5871_(stack, world, tooltip, options);
    }

    public Class<CircuitBoardBlockEntity> getBlockEntityClass() {
        return CircuitBoardBlockEntity.class;
    }

    public BlockEntityType<? extends CircuitBoardBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.CIRCUIT_BOARD.get();
    }
}

