/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.EnumProperty;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;

public abstract class OrientableComponent
extends Component {
    public static final EnumProperty<Orientation> ORIENTATION = Orientation.PROPERTY;

    public OrientableComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ORIENTATION);
    }

    @Override
    public ComponentFootprint footprint(@Nullable PlacedComponent placed) {
        ComponentFootprint footprint = super.footprint(placed);
        if (placed == null) {
            return footprint;
        }
        return footprint.rotated(placed.get(ORIENTATION));
    }
}

