/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.IRenderedComponent;
import org.patryk3211.powergrid.circuits.components.NeonBulbComponent;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.CalculatedProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.electricity.sim.special.ColdCathodeRegulatorTubeWire;
import org.patryk3211.powergrid.utility.Unit;

public class RegulatorTubeComponent
extends OrientableComponent
implements IRenderedComponent {
    public static final FloatProperty HOLDING_VOLTAGE = new FloatProperty("powergrid", "regulator_tube_vh", 60.0f, 30.0f, 500.0f);
    public static final CalculatedProperty<Float> BREAKDOWN_VOLTAGE = new CalculatedProperty<Float>("powergrid", "neon_tube_vb", placed -> Float.valueOf(placed.get(HOLDING_VOLTAGE).floatValue() * 1.4f), v -> Unit.VOLTAGE.format(v.floatValue()).getString());
    public static final CalculatedProperty<Float> HOLDING_CURRENT = new CalculatedProperty<Float>("powergrid", "neon_tube_ih", placed -> Float.valueOf(0.2f / placed.get(HOLDING_VOLTAGE).floatValue()), v -> Unit.CURRENT.formatWithPrefixes(v.floatValue()).string());

    public RegulatorTubeComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{HOLDING_VOLTAGE, BREAKDOWN_VOLTAGE, HOLDING_CURRENT, NeonBulbComponent.LIT});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        Float ih = placed.get(HOLDING_CURRENT);
        ColdCathodeRegulatorTubeWire wire = new ColdCathodeRegulatorTubeWire(placed.get(BREAKDOWN_VOLTAGE).floatValue(), placed.get(HOLDING_VOLTAGE).floatValue(), ih.floatValue(), 0.025f, builder.terminalNode(0), builder.terminalNode(1));
        wire.lit = placed.get(NeonBulbComponent.LIT);
        builder.add(wire);
        placed.add(wire);
        thermals.builder().addHeatSource(wire).setThermalMass(0.01f).setMaxPower(1.5f, 125.0f);
    }

    @Override
    public boolean tick(@NotNull PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return true;
        }
        ColdCathodeRegulatorTubeWire wire = (ColdCathodeRegulatorTubeWire)placed.wires.get(0);
        placed.onClientWorld(() -> world -> {
            LerpedFloat state;
            Object patt0$temp = placed.customData;
            if (patt0$temp instanceof LerpedFloat) {
                LerpedFloat current;
                state = current = (LerpedFloat)patt0$temp;
            } else {
                state = LerpedFloat.linear().chase(0.0, (double)0.1f, LerpedFloat.Chaser.LINEAR);
                placed.customData = state;
            }
            state.tickChaser();
            state.updateChaseTarget(wire.lit ? 1.0f : 0.0f);
        });
        if (wire.lit != placed.get(NeonBulbComponent.LIT)) {
            placed.set(NeonBulbComponent.LIT, wire.lit);
        }
        return true;
    }

    @Override
    public void render(CircuitBoardBlockEntity be, PlacedComponent placed, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        int a = 0;
        Object object = placed.customData;
        if (object instanceof LerpedFloat) {
            LerpedFloat lerped = (LerpedFloat)object;
            a = (int)(lerped.getValue(partialTicks) * 128.0f);
        }
        if (a == 0) {
            return;
        }
        SuperByteBuffer buffer = CachedBuffers.partial((PartialModel)ModdedPartialModels.REGULATOR_TUBE_GLOW, (BlockState)be.m_58900_());
        buffer.disableDiffuse().color(a, a, a, 255).light(0xF000F0).renderInto(ms, bufferSource.m_6299_(RenderTypes.additive()));
    }
}

