/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class ResistorComponent
extends OrientableComponent {
    public static final FloatProperty RESISTANCE = new FloatProperty("powergrid", "resistor_value", 100.0f, 1.0f, 1000000.0f);

    public ResistorComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{RESISTANCE, ResistorComponent.power(25.0f)});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        ElectricWire wire = builder.connect(placed.get(RESISTANCE).floatValue(), builder.terminalNode(0), builder.terminalNode(1));
        thermals.builder().setThermalMass(0.05f).setMaxPower(25.0f, 125.0f).addHeatSource(wire);
    }
}

