/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.components.IGoggleLabel;
import org.patryk3211.powergrid.circuits.components.IInteractableComponent;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.BooleanProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.thermal.ThermalBuilder;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class SwitchComponent
extends OrientableComponent
implements IInteractableComponent,
IGoggleLabel {
    public static final BooleanProperty STATE = new BooleanProperty("powergrid", "switch_state");

    public SwitchComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{STATE, LABEL, SwitchComponent.current(16.0f)});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder, @NotNull ThermalBuilder.IEmitter thermals) {
        SwitchedWire wire = builder.connectSwitch(0.1f, builder.terminalNode(0), builder.terminalNode(1), placed.get(STATE));
        placed.add(wire);
        thermals.builder().setMaxCurrent(16.0f, 0.1f, 150.0f).setThermalMass(0.01f).addHeatSource(wire);
    }

    @Override
    public VoxelShape getShape(@NotNull PlacedComponent placed) {
        return IInteractableComponent.extrudedFootprint(placed, 0.125f);
    }

    @Override
    public InteractionResult use(CircuitBoardBlockEntity be, PlacedComponent placed, Player player) {
        boolean newState = placed.get(STATE) == false;
        placed.set(STATE, newState);
        if (be.m_58904_().f_46443_) {
            Component.modelChanged(be.m_58899_());
        } else {
            if (newState) {
                ModdedSoundEvents.MICROSWITCH_ON.playOnServer(be.m_58904_(), (Vec3i)be.m_58899_());
            } else {
                ModdedSoundEvents.MICROSWITCH_OFF.playOnServer(be.m_58904_(), (Vec3i)be.m_58899_());
            }
            placed.notifyClients(STATE);
            this.stateUpdated(placed);
        }
        be.m_6596_();
        return InteractionResult.SUCCESS;
    }

    @Override
    public void stateUpdated(@NotNull PlacedComponent placed) {
        super.stateUpdated(placed);
        if (placed.wires.isEmpty()) {
            return;
        }
        ((SwitchedWire)placed.wires.get(0)).setState(placed.get(STATE));
    }

    @Override
    @NotNull
    public ResourceLocation getModelId(@NotNull PlacedComponent component) {
        return component.get(STATE) != false ? PowerGrid.asResource("switch_on") : PowerGrid.asResource("switch");
    }

    @Override
    @NotNull
    public Collection<ResourceLocation> requestedModels() {
        return List.of(PowerGrid.asResource("switch"), PowerGrid.asResource("switch_on"));
    }
}

