/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.forge;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.ComponentModels;
import org.patryk3211.powergrid.circuits.components.IRenderedComponent;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.schematic.Area;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.schematic.Point;

@OnlyIn(value=Dist.CLIENT)
public class CircuitBoardModel
implements BakedModel {
    public static final ModelResourceLocation MODEL_ID = new ModelResourceLocation(PowerGrid.asResource("circuit_board"), "");
    public static final ResourceLocation BASE_MODEL = PowerGrid.asResource("block/circuit_board");
    public static final Material COPPER_SPRITE_ID = new Material(InventoryMenu.f_39692_, PowerGrid.asResource("block/circuit_board_trace"));
    public static final Material PAD_SPRITE_ID = new Material(InventoryMenu.f_39692_, PowerGrid.asResource("block/circuit_board_pad"));
    public static final ModelProperty<List<Area>> FRONT_LAYER = new ModelProperty();
    public static final ModelProperty<List<Point>> PADS = new ModelProperty();
    public static final ModelProperty<List<PlacedComponent>> COMPONENTS = new ModelProperty();
    private static final FaceBakery bakery = new FaceBakery();
    private final TextureAtlasSprite particleSprite;
    private TextureAtlasSprite padSprite;
    private TextureAtlasSprite copperSprite;
    private final BakedModel baseModel;

    public CircuitBoardModel(BakedModel plateModel, TextureAtlasSprite padSprite, TextureAtlasSprite copperSprite) {
        this.baseModel = plateModel;
        this.padSprite = padSprite;
        this.copperSprite = copperSprite;
        this.particleSprite = this.baseModel.m_6160_();
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        return this.baseModel.m_213637_(state, face, random);
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particleSprite;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CircuitBoardBlockEntity) {
            CircuitBoardBlockEntity circuit = (CircuitBoardBlockEntity)be;
            CircuitSchematic schematic = circuit.getSchematic();
            return ModelData.builder().with(FRONT_LAYER, schematic.calculateAreas(CircuitSchematic.Layer.FRONT)).with(PADS, schematic.pads().calculatePoints()).with(COMPONENTS, List.copyOf(schematic.components())).build();
        }
        return modelData;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.baseModel.getQuads(state, side, rand, data, renderType));
        if (data.has(COMPONENTS)) {
            List components = (List)data.get(COMPONENTS);
            for (PlacedComponent placed : components) {
                IRenderedComponent rendered;
                if (placed instanceof IRenderedComponent && !(rendered = (IRenderedComponent)((Object)placed)).emitBaked()) continue;
                BakedModel model = ComponentModels.getModel(placed);
                IQuadTransformer transformer = QuadTransformers.empty();
                if (placed.has(Orientation.PROPERTY)) {
                    Orientation orientation = placed.get(Orientation.PROPERTY);
                    ComponentFootprint footprint = placed.component.footprint(null);
                    transformer = QuadTransformers.applying((Transformation)new Transformation(new Vector3f((float)placed.x / 16.0f - 0.5f, -0.375f, (float)placed.y / 16.0f - 0.5f), new Quaternionf().rotationY((float)orientation.ordinal() * (float)Math.PI * 0.5f), null, null));
                    if (orientation != Orientation.RIGHT) {
                        transformer = transformer.andThen(QuadTransformers.applying((Transformation)new Transformation(switch (orientation) {
                            default -> throw new IncompatibleClassChangeError();
                            case Orientation.DOWN -> new Vector3f((float)footprint.getHeight() / 16.0f, 0.0f, 0.0f);
                            case Orientation.LEFT -> new Vector3f((float)footprint.getWidth() / 16.0f, 0.0f, (float)footprint.getHeight() / 16.0f);
                            case Orientation.UP -> new Vector3f(0.0f, 0.0f, (float)footprint.getWidth() / 16.0f);
                            case Orientation.RIGHT -> throw new IllegalStateException();
                        }, null, null, null)));
                    }
                } else {
                    transformer = QuadTransformers.applying((Transformation)new Transformation(new Vector3f((float)placed.x / 16.0f - 0.5f, -0.375f, (float)placed.y / 16.0f - 0.5f), null, null, null));
                }
                if (placed.destroyed) {
                    transformer = transformer.andThen(QuadTransformers.applyingColor((int)64, (int)64, (int)64));
                }
                List componentQuads = model.getQuads(state, side, rand, data, renderType);
                quads.addAll(transformer.process(componentQuads));
            }
        }
        if (side == null) {
            if (data.has(FRONT_LAYER)) {
                List areas = (List)data.get(FRONT_LAYER);
                for (Area area : areas) {
                    quads.add(this.emitTrace(area));
                }
            }
            if (data.has(PADS)) {
                List pads = (List)data.get(PADS);
                for (Point pad : pads) {
                    quads.add(this.emitPad(pad));
                }
            }
        }
        if (state != null) {
            IQuadTransformer transformer = QuadTransformers.applying((Transformation)new Transformation(new Vector3f(0.5f, 0.5f, 0.5f), new Quaternionf().rotateY((float)Math.PI * (float)CircuitBoardBlock.getAngleY(state) / 180.0f).rotateX((float)Math.PI * (float)CircuitBoardBlock.getAngleX(state) / 180.0f), null, null));
            return transformer.process(quads);
        }
        return quads;
    }

    public BakedQuad emitTrace(Area area) {
        float x1 = (float)area.x1() / 1.0f;
        float y1 = (float)area.y1() / 1.0f;
        float x2 = (float)area.x2() / 1.0f;
        float y2 = (float)area.y2() / 1.0f;
        return bakery.m_111600_(new Vector3f(x1 - 8.0f, -5.95f, y1 - 8.0f), new Vector3f(x2 - 8.0f, -5.95f, y2 - 8.0f), new BlockElementFace(null, -1, "circuit_board_trace", new BlockFaceUV(new float[]{x1, y1, x2, y2}, 0)), this.copperSprite, Direction.UP, (ModelState)BlockModelRotation.X0_Y0, null, true, null);
    }

    public BakedQuad emitPad(Point point) {
        float x1 = point.x();
        float y1 = point.y();
        float x2 = x1 + 1.0f;
        float y2 = y1 + 1.0f;
        return bakery.m_111600_(new Vector3f(x1 - 8.0f, -5.95f, y1 - 8.0f), new Vector3f(x2 - 8.0f, -5.95f, y2 - 8.0f), new BlockElementFace(null, -1, "circuit_board_trace", new BlockFaceUV(new float[]{x1 /= 1.0f, y1 /= 1.0f, x2 /= 1.0f, y2 /= 1.0f}, 0)), this.padSprite, Direction.UP, (ModelState)BlockModelRotation.X0_Y0, null, true, null);
    }
}

