/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.properties;

import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentProperty<T> {
    private final String namespace;
    private final String name;
    private boolean hidden;

    public ComponentProperty(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.hidden = false;
    }

    public ComponentProperty<T> hidden() {
        this.hidden = true;
        return this;
    }

    public ResourceLocation id() {
        return new ResourceLocation(this.namespace, this.name);
    }

    public String translationKey() {
        return this.namespace + ".component.property." + this.name;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public abstract T parse(String var1) throws RuntimeException;

    public abstract String toString(T var1);

    public abstract T read(@Nullable Tag var1);

    public abstract Tag write(T var1);

    public abstract T defaultValue();

    public String toString() {
        return super.toString() + "(" + this.id().toString() + ")";
    }
}

