/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.properties;

import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;

public class IntProperty
extends ComponentProperty<Integer> {
    private final int defaultValue;
    private final int min;
    private final int max;

    public IntProperty(String namespace, String name, int defaultValue, int min, int max) {
        super(namespace, name);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
    }

    private int limit(int value) {
        if (value < this.min) {
            return this.min;
        }
        if (value > this.max) {
            return this.max;
        }
        return value;
    }

    @Override
    public Integer parse(String str) throws NumberFormatException {
        int value = Integer.parseInt(str);
        return this.limit(value);
    }

    @Override
    public String toString(Integer value) {
        return Integer.toString(value);
    }

    @Override
    public Integer read(@Nullable Tag element) {
        if (element == null) {
            return this.defaultValue;
        }
        if (element.m_7060_() != 3) {
            return this.defaultValue;
        }
        int value = ((IntTag)element).m_7047_();
        return this.limit(value);
    }

    @Override
    public Tag write(Integer value) {
        return IntTag.m_128679_((int)value);
    }

    @Override
    public Integer defaultValue() {
        return this.defaultValue;
    }
}

