/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.components.properties.BooleanProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.components.properties.IntProperty;
import org.patryk3211.powergrid.circuits.components.properties.PropertyEntry;
import org.patryk3211.powergrid.circuits.components.properties.StringProperty;
import org.patryk3211.powergrid.circuits.gui.BooleanPropertyWidget;
import org.patryk3211.powergrid.circuits.gui.ConstantPropertyWidget;
import org.patryk3211.powergrid.circuits.gui.PropertyWidget;
import org.patryk3211.powergrid.circuits.gui.TextFieldPropertyWidget;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;

public class ComponentPropertiesWidget
extends AbstractSimiWidget {
    public static final ResourceLocation PROPERTIES = PowerGrid.texture("gui/circuit_design_table_properties");
    private final Font textRenderer;
    private final int right;
    @Nullable
    private PlacedComponent component;
    private final List<PropertyWidget<?, ?>> propertyWidgets = new ArrayList();
    private int propertyCount = 0;

    public ComponentPropertiesWidget(Font textRenderer, int right, int y) {
        super(right - 150, y, 150, 150);
        this.right = right;
        this.textRenderer = textRenderer;
    }

    public void setComponent(@Nullable PlacedComponent component) {
        this.component = component;
        this.propertyWidgets.clear();
        if (component != null) {
            ImmutableList<ComponentProperty<?>> properties = component.component.getProperties();
            MutableComponent title = Component.m_237115_((String)component.component.getRequiredItem().m_5524_());
            int titleWidth = this.textRenderer.m_92852_((FormattedText)title);
            int maxTextLength = 0;
            for (ComponentProperty property : properties) {
                String propertyKey;
                int length;
                if (property.isHidden() || (length = this.textRenderer.m_92852_((FormattedText)Component.m_237115_((String)(propertyKey = property.translationKey())))) <= maxTextLength) continue;
                maxTextLength = length;
            }
            int requiredWidth = Math.max(maxTextLength + 6 + 60 + 5, titleWidth + 20);
            int width = Math.max(requiredWidth, 120);
            this.m_93674_(width);
            this.m_252865_(this.right - width);
            int x = this.right - 60;
            int y = this.m_252907_() + 16;
            for (ComponentProperty property : properties) {
                if (property.isHidden()) continue;
                if (property instanceof FloatProperty || property instanceof IntProperty || property instanceof StringProperty) {
                    this.propertyWidgets.add(new TextFieldPropertyWidget(this.textRenderer, x, y, component.getEntry(property)));
                } else if (property instanceof BooleanProperty) {
                    BooleanProperty bProp = (BooleanProperty)property;
                    this.propertyWidgets.add(new BooleanPropertyWidget(this.textRenderer, x, y, component.getEntry(bProp)));
                } else {
                    this.propertyWidgets.add(new ConstantPropertyWidget(this.textRenderer, x, y, component.getEntry(property)));
                }
                y += 20;
            }
            this.propertyCount = this.propertyWidgets.size();
        } else {
            this.m_93674_(120);
            this.m_252865_(this.right - 120);
            this.propertyCount = 0;
        }
    }

    protected void doRender(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.component == null) {
            return;
        }
        PoseStack ms = ctx.m_280168_();
        ms.m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        int centerSliceSize = Math.max(this.f_93618_ - 120, 0);
        ctx.m_280218_(PROPERTIES, 0, 0, 0, 0, 60, 16);
        if (this.f_93618_ > 120) {
            ctx.m_280543_(PROPERTIES, 60, 0, centerSliceSize, 16, 61, 0, 30, 16);
        }
        ctx.m_280218_(PROPERTIES, 60 + centerSliceSize, 0, 92, 0, 60, 16);
        String key = this.component.component.getRequiredItem().m_5524_();
        ctx.m_280653_(this.textRenderer, (Component)Component.m_237115_((String)key), this.m_5711_() / 2, 5, -1);
        ctx.m_280543_(PROPERTIES, 0, 16, 60, this.propertyCount * 20, 0, 29, 60, 20);
        if (this.f_93618_ > 120) {
            ctx.m_280543_(PROPERTIES, 60, 16, centerSliceSize, this.propertyCount * 20, 61, 29, 30, 20);
        }
        ms.m_85836_();
        ms.m_252880_((float)(-this.m_252754_()), (float)(-this.m_252907_()), 0.0f);
        int yOffset = 16;
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            yOffset = widget.m_252907_() + widget.m_93694_() - this.m_252907_();
            String propertyKey = ((PropertyEntry)widget.property).property.translationKey();
            int end = ctx.m_280614_(this.textRenderer, (Component)Component.m_237115_((String)propertyKey), this.m_252754_() + 6, widget.m_252907_() + 6, -10461088, false);
            widget.m_88315_(ctx, mouseX, mouseY, partialTicks);
            MutableComponent summary = Component.m_264568_((String)(propertyKey + ".summary"), (String)"");
            if (summary.getString().isEmpty()) continue;
            int x1 = this.m_252754_() + 6;
            int y1 = widget.m_252907_() + 6;
            List lines = this.textRenderer.m_92923_((FormattedText)summary, this.m_5711_());
            if (mouseX < x1 || mouseY < y1 || mouseX >= end || mouseY >= y1 + 16) continue;
            ctx.m_280245_(this.textRenderer, lines, mouseX, mouseY);
        }
        ms.m_85849_();
        ms.m_252880_(0.0f, (float)yOffset, 0.0f);
        ctx.m_280218_(PROPERTIES, 0, 0, 0, 50, 60, 6);
        if (this.f_93618_ > 120) {
            ctx.m_280543_(PROPERTIES, 60, 0, centerSliceSize, 6, 61, 50, 30, 6);
        }
        ctx.m_280218_(PROPERTIES, 60 + centerSliceSize, 0, 92, 50, 60, 6);
        ItemStack stack = this.component.footprint().getRenderedStack();
        if (stack != null) {
            ctx.m_280218_(PROPERTIES, this.m_5711_() / 2 - 8, 4, 240, 0, 16, 10);
            ms.m_85836_();
            ms.m_252880_((float)(this.m_5711_() / 2), 14.0f, 0.0f);
            ms.m_85841_(3.0f, 3.0f, 1.0f);
            ms.m_252880_(-8.0f, 0.0f, 0.0f);
            ctx.m_280480_(stack, 0, 0);
            ms.m_85849_();
        }
    }

    public void tick() {
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            widget.tick();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.component == null) {
            return false;
        }
        boolean result = false;
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            result |= widget.m_6375_(mouseX, mouseY, button);
        }
        return result;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean result = false;
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            result |= widget.m_7933_(keyCode, scanCode, modifiers);
        }
        return result;
    }

    public boolean m_5534_(char chr, int modifiers) {
        boolean result = false;
        for (PropertyWidget<?, ?> widget : this.propertyWidgets) {
            result |= widget.m_5534_(chr, modifiers);
        }
        return result;
    }
}

