/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.schematic;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.schematic.Point;

public class ComponentFootprint {
    private static final ResourceLocation ARROWS = PowerGrid.texture("gui/circuit_arrows");
    private static final PadData NONE = new PadData(-1, null, null);
    private final int width;
    private final int height;
    private final SortedMap<Point, PadData> pads;
    private final boolean outline;
    @Nullable
    private final Supplier<Item> renderedItem;
    @Nullable
    private final Orientation arrow;
    private ItemStack renderedStack;

    protected ComponentFootprint(int width, int height, SortedMap<Point, PadData> pads, boolean outline, @Nullable Supplier<Item> renderedItem, @Nullable Orientation arrow) {
        this.width = width;
        this.height = height;
        this.pads = pads;
        this.outline = outline;
        this.renderedItem = renderedItem;
        this.arrow = arrow;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderPads(@NotNull GuiGraphics ctx, int x, int y) {
        PoseStack ms = ctx.m_280168_();
        ms.m_85836_();
        ms.m_85841_(0.25f, 0.25f, 0.25f);
        for (Point point : this.pads.keySet()) {
            int x1 = (point.x() + x) * 4;
            int y1 = (point.y() + y) * 4;
            ctx.m_280509_(x1 + 1, y1 + 1, x1 + 3, y1 + 3, -215549);
        }
        ms.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(@NotNull GuiGraphics ctx, int x, int y, boolean hovering) {
        PoseStack ms = ctx.m_280168_();
        if (this.outline) {
            ms.m_85836_();
            ms.m_85841_(0.5f, 0.5f, 0.5f);
            ctx.m_280637_(x * 2, y * 2, this.width * 1 * 2, this.height * 1 * 2, -2131724050);
            ms.m_85849_();
        }
        this.renderPads(ctx, x, y);
        if (this.renderedItem != null && !hovering) {
            ms.m_85836_();
            int maxSize = 2;
            float scale = (float)Math.min(Math.min(this.width, this.height), 2) / 16.0f * 1.0f;
            if (this.width > 2 && this.height > 2) {
                ms.m_252880_((float)(this.width - 2) * 0.5f, (float)(this.height - 2) * 0.5f, 0.0f);
            } else if (this.width > this.height) {
                float offset = (float)(this.width - this.height) * 0.5f;
                ms.m_252880_(offset, 0.0f, 0.0f);
            } else if (this.height > this.width) {
                float offset = (float)(this.height - this.width) * 0.5f;
                ms.m_252880_(0.0f, offset, 0.0f);
            }
            ms.m_85841_(scale, scale, scale);
            ctx.m_280480_(this.getRenderedStack(), (int)((float)x / scale), (int)((float)y / scale));
            ms.m_85849_();
        }
        if (this.arrow != null) {
            ms.m_85836_();
            int u = this.arrow.ordinal() % 2 * 8;
            int v = this.arrow.ordinal() / 2 * 8;
            ms.m_252880_((float)x + (float)(this.width * 1) * 0.5f, (float)y + (float)(this.height * 1) * 0.5f, 0.0f);
            switch (this.arrow) {
                case RIGHT: {
                    ms.m_252880_((float)(this.width / 2), 0.0f, 0.0f);
                    break;
                }
                case LEFT: {
                    ms.m_252880_((float)(-this.width / 2), 0.0f, 0.0f);
                    break;
                }
                case DOWN: {
                    ms.m_252880_(0.0f, (float)(this.height / 2), 0.0f);
                    break;
                }
                case UP: {
                    ms.m_252880_(0.0f, (float)(-this.height / 2), 0.0f);
                }
            }
            ms.m_85841_(0.25f, 0.25f, 1.0f);
            ms.m_252880_(-4.0f, -4.0f, 0.0f);
            ctx.m_280163_(ARROWS, 0, 0, (float)u, (float)v, 8, 8, 16, 16);
            ms.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderPadIndices(@NotNull GuiGraphics ctx, @NotNull Font textRenderer, int x, int y) {
        PoseStack ms = ctx.m_280168_();
        ms.m_85836_();
        int scale = 12;
        ms.m_252880_(0.5f, 0.5f, 100.0f);
        ms.m_85841_(1.0f / (float)scale, 1.0f / (float)scale, 1.0f);
        for (Map.Entry<Point, PadData> entry : this.pads.entrySet()) {
            Point point = entry.getKey();
            int x1 = (point.x() + x) * scale;
            int y1 = (point.y() + y) * scale;
            Component text = entry.getValue().shortText();
            if (text == null) continue;
            int width = textRenderer.m_92852_((FormattedText)text);
            ctx.m_280614_(textRenderer, text, x1 - width / 2, y1 - 4, -1, false);
        }
        ms.m_85849_();
    }

    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        PadData pad = (PadData)this.pads.get(new Point(mouseX, mouseY));
        if (pad == null) {
            return null;
        }
        return pad.tooltip;
    }

    @Nullable
    public ItemStack getRenderedStack() {
        if (this.renderedItem == null) {
            return null;
        }
        if (this.renderedStack == null) {
            this.renderedStack = this.renderedItem.get().m_7968_();
        }
        return this.renderedStack;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Map<Point, PadData> getPads() {
        return this.pads;
    }

    public ComponentFootprint rotated(Orientation orientation) {
        int height;
        int width;
        if (orientation == Orientation.UP || orientation == Orientation.DOWN) {
            width = this.height;
            height = this.width;
        } else {
            width = this.width;
            height = this.height;
        }
        TreeMap<Point, PadData> pads = new TreeMap<Point, PadData>();
        for (Map.Entry<Point, PadData> pad : this.pads.entrySet()) {
            int x;
            Point position = pad.getKey();
            pads.put(new Point(x, switch (orientation) {
                case Orientation.RIGHT -> {
                    x = position.x();
                    yield position.y();
                }
                case Orientation.DOWN -> {
                    x = this.height - position.y() - 1;
                    yield position.x();
                }
                case Orientation.LEFT -> {
                    x = this.width - position.x() - 1;
                    yield this.height - position.y() - 1;
                }
                case Orientation.UP -> {
                    x = position.y();
                    yield this.width - position.x() - 1;
                }
                default -> throw new IllegalStateException("Invalid orientation: " + String.valueOf((Object)orientation));
            }), pad.getValue());
        }
        ComponentFootprint footprint = new ComponentFootprint(width, height, pads, this.outline, this.renderedItem, this.arrow == null ? null : this.arrow.rotate(orientation));
        footprint.renderedStack = this.renderedStack;
        return footprint;
    }

    public record PadData(int nodeIndex, @Nullable Component tooltip, @Nullable Component shortText) {
    }

    public static class Builder {
        private final int width;
        private final int height;
        private final SortedMap<Point, PadData> pads = new TreeMap<Point, PadData>();
        private Supplier<Item> itemSupplier;
        private boolean outline = false;
        private Orientation arrow = null;
        @Nullable
        private final String translationKey;
        public final Map<String, String> translatedPads = new HashMap<String, String>();

        public Builder(int width, int height) {
            this(width, height, null);
        }

        public Builder(int width, int height, String translationKeyBase) {
            this.width = width;
            this.height = height;
            this.translationKey = translationKeyBase;
        }

        private void validatePad(int x, int y) {
            if (x < 0 || y < 0 || x >= this.width * 1 || y >= this.height * 1) {
                throw new IllegalArgumentException("Pad position must be inside defined footprint size");
            }
        }

        public Builder addPad(int x, int y) {
            this.validatePad(x, y);
            this.pads.put(new Point(x, y), NONE);
            return this;
        }

        public Builder addPad(int x, int y, int nodeIndex) {
            return this.addPad(x, y, nodeIndex, (Component)null, null);
        }

        public Builder addPad(int x, int y, int nodeIndex, @Nullable Component tooltip, @Nullable Component shortText) {
            this.validatePad(x, y);
            this.pads.put(new Point(x, y), new PadData(nodeIndex, tooltip, shortText));
            return this;
        }

        public Builder addPad(int x, int y, int nodeIndex, String defaultLang, String defaultShort) {
            if (this.translationKey == null) {
                throw new IllegalCallerException("This method may only be used when the translation key base is set");
            }
            String key = this.translationKey + "." + nodeIndex;
            this.translatedPads.put(key, defaultLang);
            if (defaultShort != null) {
                this.translatedPads.put(key + ".short", defaultShort);
            }
            return this.addPad(x, y, nodeIndex, (Component)Component.m_237115_((String)key), (Component)(defaultShort == null ? null : Component.m_237115_((String)(key + ".short"))));
        }

        public Builder withOutline() {
            this.outline = true;
            return this;
        }

        public Builder withItem(Supplier<Item> itemSupplier) {
            this.itemSupplier = itemSupplier;
            return this;
        }

        public Builder withArrow(Orientation facing) {
            this.arrow = facing;
            return this;
        }

        public Builder withArrow() {
            this.arrow = Orientation.RIGHT;
            return this;
        }

        public ComponentFootprint build() {
            TreeSet<Integer> padIndices = new TreeSet<Integer>();
            for (PadData pad : this.pads.values()) {
                if (pad.nodeIndex < 0) continue;
                padIndices.add(pad.nodeIndex);
            }
            if (!padIndices.isEmpty()) {
                if ((Integer)padIndices.first() != 0) {
                    throw new IllegalStateException("Footprint pad indices must start from 0");
                }
                if ((Integer)padIndices.last() != padIndices.size() - 1) {
                    throw new IllegalStateException("Footprint pad indices must not contain any gaps");
                }
            }
            return new ComponentFootprint(this.width, this.height, this.pads, this.outline, this.itemSupplier, this.arrow);
        }
    }
}

