/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.compat.tfmg;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockValues;
import com.drmangotea.tfmg.content.electricity.base.ElectricNetworkManager;
import com.drmangotea.tfmg.content.electricity.base.ElectricalGroup;
import com.drmangotea.tfmg.content.electricity.base.ElectricalNetwork;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.NetworkUpdatePacket;
import com.drmangotea.tfmg.registry.TFMGPackets;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.compat.tfmg.TFMGBridgeElectricBehaviour;
import org.patryk3211.powergrid.electricity.deviceconnector.BridgeElectricBehaviour;
import org.patryk3211.powergrid.electricity.deviceconnector.DeviceConnectorBlock;
import org.patryk3211.powergrid.electricity.deviceconnector.DeviceConnectorBlockEntity;

public class TFMGCompatDeviceConnectorBlockEntity
extends DeviceConnectorBlockEntity
implements IElectric {
    public ElectricBlockValues data = new ElectricBlockValues(this.getPos());
    private int voltage;
    private boolean powerRefresh = false;
    private boolean firstUpdate = false;

    public TFMGCompatDeviceConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.data.connectNextTick = true;
        this.data.group = new ElectricalGroup(-1);
    }

    @Override
    protected BridgeElectricBehaviour makeBridge() {
        return new TFMGBridgeElectricBehaviour(this, this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)DeviceConnectorBlock.FACING)), () -> this.converterWire);
    }

    public void lazyTick() {
        super.lazyTick();
        int newVoltage = (int)Math.abs(this.converterWire.potentialDifference());
        if (newVoltage != this.voltage) {
            if (this.firstUpdate) {
                this.firstUpdate = false;
            } else {
                this.voltage = newVoltage;
                this.updateNetwork();
                this.refreshPower();
            }
        }
        this.lazyTickElectricity();
    }

    private void refreshPower() {
        this.powerRefresh = false;
        float power = this.getGeneratorLoad();
        float resistance = (float)(this.voltage * this.voltage) / power;
        if (power > 0.0f && resistance > 0.0f) {
            this.converterWire.setResistance(resistance);
            this.converterWire.setState(true);
        } else {
            this.converterWire.setState(false);
        }
    }

    public void tick() {
        super.tick();
        if (this.powerRefresh) {
            this.refreshPower();
        }
        this.tickElectricity();
    }

    public long getPos() {
        return this.m_58899_().m_121878_();
    }

    public LevelAccessor getLevelAccessor() {
        return this.f_58857_;
    }

    public ElectricBlockValues getData() {
        return this.data;
    }

    @Override
    public float resistance() {
        return 0.0f;
    }

    public int voltageGeneration() {
        return this.voltage;
    }

    public int powerGeneration() {
        return (Integer)ModdedConfigs.server().electricity.tfmgConnectorPower.get();
    }

    public int frequencyGeneration() {
        return 0;
    }

    public int getNetworkResistance() {
        return this.data.networkResistance;
    }

    public void updateNextTick() {
        this.data.updateNextTick = true;
    }

    public void onNetworkChanged(int oldVoltage, int oldPower) {
        this.powerRefresh = true;
    }

    public void updateNetwork() {
        this.getOrCreateElectricNetwork().updateNetwork();
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new NetworkUpdatePacket(BlockPos.m_122022_((long)this.getPos())));
        }
        this.sendData();
    }

    public void sendStuff() {
        this.sendData();
    }

    public void setVoltage(int i) {
        this.data.voltage = i;
    }

    public void setFrequency(int i) {
        this.data.frequency = i;
    }

    public void setNetworkResistance(int i) {
        this.data.networkResistance = i;
    }

    public void setNetwork(long network) {
        this.data.electricalNetworkId = network;
        if (network != this.getPos()) {
            ((Map)ElectricNetworkManager.networks.get(this.m_58904_())).remove(this.getPos());
        }
    }

    public boolean destroyed() {
        return this.data.destroyed;
    }

    @Override
    public void remove() {
        super.remove();
        this.data.destroyed = true;
        for (Direction d : Direction.values()) {
            IElectric be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(d) || !((blockEntity = this.getLevelAccessor().m_7702_(BlockPos.m_122022_((long)this.getPos()).m_121945_(d))) instanceof IElectric) || !(be = (IElectric)blockEntity).hasElectricitySlot(d.m_122424_())) continue;
            ((Map)ElectricNetworkManager.networks.get(this.m_58904_())).remove(be.getPos());
            be.setNetwork(be.getPos());
            be.onPlaced();
            be.updateNextTick();
        }
        if (this.data.electricalNetworkId != this.getPos()) {
            this.getOrCreateElectricNetwork().getMembers().remove(this);
        }
        if (this.data.electricalNetworkId == this.getPos()) {
            ((Map)ElectricNetworkManager.networks.get(this.m_58904_())).remove(this.getData().getId());
        }
    }

    public ElectricalNetwork getOrCreateElectricNetwork() {
        if (this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.data.electricalNetworkId)) instanceof IElectric) {
            return TFMG.NETWORK_MANAGER.getOrCreateNetworkFor((IElectric)this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.data.electricalNetworkId)));
        }
        ((Map)ElectricNetworkManager.networks.get(this.m_58904_())).remove(this.data.electricalNetworkId);
        return TFMG.NETWORK_MANAGER.getOrCreateNetworkFor((IElectric)this);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("GroupId", this.data.group.id);
        compound.m_128350_("GroupResistance", this.data.group.resistance);
        compound.m_128405_("PrevVoltage", this.voltage);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.data.group = new ElectricalGroup(compound.m_128451_("GroupId"));
        this.data.group.resistance = compound.m_128457_("GroupResistance");
        if (!clientPacket) {
            this.data.connectNextTick = true;
            this.voltage = compound.m_128451_("PrevVoltage");
        }
    }

    public boolean hasElectricitySlot(Direction direction) {
        return this.m_58900_().m_61143_((Property)DeviceConnectorBlock.FACING) == direction;
    }
}

