/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.config.ResistanceValues;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;

public abstract class ElectricBlock
extends Block
implements IElectric {
    private BlockStateTerminalCollection terminals = null;
    private ImmutableMap<BlockState, VoxelShape> outlines = null;

    public ElectricBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected void setTerminalCollection(BlockStateTerminalCollection terminals) {
        this.terminals = terminals;
        Function<BlockState, VoxelShape> mapper = terminals.shapeMapper();
        if (mapper != null) {
            this.outlines = this.m_152458_(mapper);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        IBE.onRemove((BlockState)state, (Level)world, (BlockPos)pos, (BlockState)newState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.outlines != null) {
            return (VoxelShape)this.outlines.get((Object)state);
        }
        return super.m_5940_(state, world, pos, context);
    }

    @Override
    public ITerminalPlacement terminal(BlockState state, int index) {
        if (this.terminals != null) {
            return this.terminals.get(state, index);
        }
        return null;
    }

    @Override
    public int terminalCount() {
        if (this.terminals != null) {
            return this.terminals.count();
        }
        return 0;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = IElectric.super.onWrenched(state, context);
        if (result == InteractionResult.SUCCESS && !context.m_43725_().f_46443_) {
            ElectricBlock.refreshConnectionEntities(context.m_43725_(), context.m_8083_());
        }
        return result;
    }

    public static void refreshConnectionEntities(Level world, BlockPos pos) {
        ElectricBehaviour behaviour = (ElectricBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, ElectricBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.refreshConnectionEntities();
        }
    }

    public float resistance() {
        return ResistanceValues.get(this);
    }

    public float resistance(String suffix) {
        return ResistanceValues.get(this, suffix);
    }
}

