/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;

public abstract class ElectricBlockEntity
extends SmartBlockEntity
implements IElectricEntity {
    protected ElectricBehaviour electricBehaviour;
    @Nullable
    protected ThermalBehaviour thermalBehaviour;

    public ElectricBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.electricBehaviour = new ElectricBehaviour(this);
        behaviours.add(this.electricBehaviour);
        this.thermalBehaviour = this.specifyThermalBehaviour();
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
    }

    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return null;
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    public ElectricBehaviour getElectricBehaviour() {
        return this.electricBehaviour;
    }

    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }
}

