/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base.terminals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.SimpleTerminalCollectionBuilder;

public class AxisRotatedTerminalCollection {
    private final TerminalBoundingBox[][] terminals;

    private AxisRotatedTerminalCollection(TerminalBoundingBox[][] terminals) {
        this.terminals = terminals;
    }

    public TerminalBoundingBox get(Rotation rotation, int index) {
        return this.terminals[rotation.ordinal()][index];
    }

    public static Builder builder(Direction.Axis axis) {
        return new Builder(axis);
    }

    public static class Builder
    extends SimpleTerminalCollectionBuilder<Builder, AxisRotatedTerminalCollection> {
        private final List<Rotation> rotations = new ArrayList<Rotation>();
        private final Direction.Axis axis;

        private Builder(Direction.Axis axis) {
            this.axis = axis;
        }

        public Builder with(Rotation rotation) {
            this.rotations.add(rotation);
            return this;
        }

        public Builder with(Rotation ... rotations) {
            Collections.addAll(this.rotations, rotations);
            return this;
        }

        @Override
        public AxisRotatedTerminalCollection build() {
            TerminalBoundingBox[][] terminals = new TerminalBoundingBox[4][this.terminals.size()];
            for (Rotation rotation : this.rotations) {
                for (int j = 0; j < this.terminals.size(); ++j) {
                    terminals[rotation.ordinal()][j] = ((TerminalBoundingBox)this.terminals.get(j)).rotate(this.axis, rotation);
                }
            }
            return new AxisRotatedTerminalCollection(terminals);
        }
    }
}

