/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.battery.AbstractBatteryBlock;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;

public class BatteryBlockEntity
extends ElectricBlockEntity {
    protected VoltageSourceCoupling sourceCoupling;
    protected final BatterySpec spec;
    protected double capacity;
    protected double energy;
    protected boolean refreshLinks;

    public BatteryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.spec = ((AbstractBatteryBlock)state.m_60734_()).getSpec();
        this.capacity = this.spec.getMaxCharge();
        this.energy = this.spec.getInitialCharge();
        this.updateParameters();
        this.setLazyTickRate(20);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    public void updateParameters() {
        if (this.energy <= 0.0) {
            return;
        }
        float chargeLevel = (float)(this.energy / this.capacity);
        this.sourceCoupling.setVoltage(this.spec.calculateVoltage(chargeLevel));
        this.sourceCoupling.setResistance(this.spec.calculateResistance(chargeLevel));
    }

    public float calculatePower() {
        return -this.sourceCoupling.getCurrent() * this.sourceCoupling.getVoltage();
    }

    public void tick() {
        if (this.sourceCoupling != null) {
            float I = this.sourceCoupling.getCurrent();
            if (this.thermalBehaviour != null && this.sourceCoupling.isConverged()) {
                this.thermalBehaviour.applyTickPower(I * I * this.sourceCoupling.getResistance());
            }
        }
        super.tick();
        if (this.sourceCoupling == null) {
            return;
        }
        float power = this.calculatePower();
        if (Math.abs(power) > 0.05f) {
            this.refreshLinks = true;
        }
        this.energy -= (double)(power * 0.05f);
        if (this.energy <= 0.0) {
            this.energy = 0.0;
            this.sourceCoupling.setVoltage(0.0f);
            return;
        }
        if (this.energy >= this.capacity) {
            this.energy = this.capacity;
        }
        this.m_6596_();
        this.updateParameters();
    }

    public void lazyTick() {
        super.lazyTick();
        this.sendData();
        if (this.refreshLinks) {
            this.refreshLinks = false;
            DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_);
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128347_("Energy", this.energy);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.energy = tag.m_128459_("Energy");
        this.updateParameters();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.sourceCoupling = builder.addInternalNode(VoltageSourceCoupling.class, builder.terminalNode(0), builder.terminalNode(1), Float.valueOf(0.5f));
    }

    public void setEnergy(double energy) {
        this.energy = energy;
        this.updateParameters();
        this.notifyUpdate();
    }

    public double getCapacity() {
        return this.capacity;
    }

    public double getEnergy() {
        return this.energy;
    }
}

