/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import java.util.function.Function;
import java.util.function.Supplier;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;

public class SimpleBatterySpec
implements BatterySpec {
    public static final SimpleBatterySpec ACID_BATTERY = new SimpleBatterySpec(7200.0f, () -> Float.valueOf(7200.0f * ModdedConfigs.server().electricity.acidBatteryInitialCharge.getF()), e -> Float.valueOf(1.2f * e.floatValue() + 11.5f), e -> Float.valueOf(Math.min(10000.0f, (float)Math.exp(-21.18323 * (double)e.floatValue() + 10.58157) + 0.1f)));
    private final float maxCharge;
    private final Supplier<Float> initialCharge;
    private final Function<Float, Float> voltageFunction;
    private final Function<Float, Float> resistanceFunction;

    public SimpleBatterySpec(float maxCharge, float initialCharge, Function<Float, Float> voltageFunction, Function<Float, Float> resistanceFunction) {
        this.maxCharge = maxCharge;
        this.initialCharge = () -> Float.valueOf(initialCharge);
        this.voltageFunction = voltageFunction;
        this.resistanceFunction = resistanceFunction;
    }

    public SimpleBatterySpec(float maxCharge, Supplier<Float> initialCharge, Function<Float, Float> voltageFunction, Function<Float, Float> resistanceFunction) {
        this.maxCharge = maxCharge;
        this.initialCharge = initialCharge;
        this.voltageFunction = voltageFunction;
        this.resistanceFunction = resistanceFunction;
    }

    @Override
    public float getMaxCharge() {
        return this.maxCharge;
    }

    @Override
    public float getInitialCharge() {
        return this.initialCharge.get().floatValue();
    }

    @Override
    public float calculateVoltage(float chargeLevel) {
        return this.voltageFunction.apply(Float.valueOf(chargeLevel)).floatValue();
    }

    @Override
    public float calculateResistance(float chargeLevel) {
        return this.resistanceFunction.apply(Float.valueOf(chargeLevel)).floatValue();
    }
}

