/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.creative;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.resistor.ResistorBlockEntity;
import org.patryk3211.powergrid.electricity.resistor.ResistorBoxTransform;
import org.patryk3211.powergrid.electricity.resistor.ResistorValueBehaviour;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.NumberFormats;
import org.patryk3211.powergrid.utility.Unit;

public class CreativeResistorBlockEntity
extends ResistorBlockEntity
implements IHaveGoggleInformation {
    public CreativeResistorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected ResistorValueBehaviour makeScroll() {
        return new ResistorValueBehaviour((Component)Lang.translateDirect("devices.resistor.resistance", new Object[0]), this, (ValueBoxTransform)new ResistorBoxTransform(), 3, 72);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate("gui.creative_resistor.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.creative_resistor.resistance", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        double resistance = this.wire.getResistance();
        String resistanceText = NumberFormats.formatPrecise(resistance);
        Lang.builder().text(resistanceText).add(Component.m_130674_((String)" ")).add(Unit.RESISTANCE.get()).style(ChatFormatting.BLUE).forGoggles(tooltip, 1);
        Lang.builder().translate("gui.creative_resistor.current", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float current = this.wire.current();
        String currentText = NumberFormats.formatPrecise(current);
        Lang.builder().text(currentText).add(Component.m_130674_((String)" ")).add(Unit.CURRENT.get()).style(ChatFormatting.GREEN).forGoggles(tooltip, 1);
        Lang.builder().translate("gui.creative_resistor.power", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        String power = NumberFormats.formatPrecise((double)(current * current) * resistance);
        Lang.builder().text(power).add(Component.m_130674_((String)" ")).add(Unit.POWER.get()).style(ChatFormatting.YELLOW).forGoggles(tooltip, 1);
        return true;
    }
}

