/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.deviceconnector;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ProxyElectricBehaviour;
import org.patryk3211.powergrid.electricity.deviceconnector.forge.BridgeElectricBehaviourImpl;
import org.patryk3211.powergrid.electricity.febridge.IFEBridgeHandler;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class BridgeElectricBehaviour
extends ProxyElectricBehaviour {
    private IFEBridgeHandler bridgeBehaviour;
    private long readEnergy;
    public long currentRate;
    private boolean fetched = false;
    private final Supplier<SwitchedWire> converterWire;
    private boolean isProxy = false;

    public <T extends SmartBlockEntity> BridgeElectricBehaviour(T be, BlockPos behaviourPosition, Supplier<SwitchedWire> converterWire) {
        super(be, true, () -> behaviourPosition);
        this.converterWire = converterWire;
    }

    protected void constructBehaviours() {
        Level world = this.getWorld();
        if (!world.m_46749_((BlockPos)this.behaviourPosition.get())) {
            return;
        }
        this.fetched = true;
        ElectricBehaviour mainBehaviour = (ElectricBehaviour)BridgeElectricBehaviour.get((BlockGetter)world, (BlockPos)((BlockPos)this.behaviourPosition.get()), (BehaviourType)TYPE);
        if (mainBehaviour != null) {
            this.isProxy = true;
            return;
        }
        this.bridgeBehaviour = BridgeElectricBehaviour.makeFEHandler((BlockEntity)this.blockEntity);
        if (this.bridgeBehaviour == null) {
            world.m_46961_(this.getPos(), true);
            return;
        }
        this.bridgeBehaviour.setAmount(this.readEnergy);
    }

    @Override
    public Optional<ElectricBehaviour> getMainBehaviour() {
        if (!this.fetched) {
            this.constructBehaviours();
        }
        return super.getMainBehaviour();
    }

    @Nullable
    public IFEBridgeHandler getBridgeBehaviour() {
        if (!this.fetched) {
            this.constructBehaviours();
        }
        return this.bridgeBehaviour;
    }

    protected boolean isProxy() {
        if (!this.fetched) {
            this.constructBehaviours();
        }
        return this.isProxy;
    }

    @Override
    public void initialize() {
        if (this.isProxy()) {
            super.initialize();
        } else {
            super.baseInitialize();
        }
    }

    @Override
    public void unload() {
        if (!this.isProxy()) {
            super.baseUnload();
        }
    }

    @Override
    public void remove() {
        if (this.isProxy()) {
            super.remove();
        } else {
            super.baseRemove();
        }
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (this.bridgeBehaviour != null) {
            this.bridgeBehaviour.setAmount(nbt.m_128454_("Energy"));
        } else {
            this.readEnergy = nbt.m_128454_("Energy");
        }
        if (clientPacket) {
            this.currentRate = nbt.m_128454_("Rate");
        }
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.bridgeBehaviour != null) {
            nbt.m_128356_("Energy", this.bridgeBehaviour.getAmount());
            if (clientPacket) {
                nbt.m_128356_("Rate", this.currentRate);
            }
        }
    }

    public void tick() {
        super.tick();
        IFEBridgeHandler energyStorage = this.getBridgeBehaviour();
        if (energyStorage == null) {
            return;
        }
        SwitchedWire wire = this.converterWire.get();
        Level world = this.getWorld();
        energyStorage.charge(wire);
        long moved = energyStorage.moveEnergy();
        if (!world.f_46443_) {
            if (moved != this.currentRate) {
                this.currentRate = moved;
                this.blockEntity.sendData();
            }
        } else if (moved == 0L) {
            long amount = energyStorage.getAmount();
            energyStorage.setAmount(Math.max(amount - this.currentRate, 0L));
        }
        energyStorage.manageWire(wire);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFEBridgeHandler makeFEHandler(BlockEntity be) {
        return BridgeElectricBehaviourImpl.makeFEHandler(be);
    }

    public boolean isFE() {
        return this.bridgeBehaviour != null;
    }

    public long getBufferedAmount() {
        return this.bridgeBehaviour.getAmount();
    }
}

