/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.deviceconnector.forge;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.patryk3211.powergrid.electricity.febridge.IFEBridgeHandler;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class FEBridgeEnergyStorage
implements IEnergyStorage,
IFEBridgeHandler {
    private final BlockEntity be;
    public long capacity;
    public long amount;

    public FEBridgeEnergyStorage(BlockEntity be) {
        this.be = be;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public int receiveEnergy(int amount, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxAmount, boolean simulate) {
        if (maxAmount <= 0) {
            return 0;
        }
        int extracted = Math.toIntExact(Math.min((long)maxAmount, this.amount));
        if (extracted > 0 && !simulate) {
            this.amount -= (long)extracted;
        }
        this.be.m_6596_();
        return extracted;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    public int getEnergyStored() {
        return Math.toIntExact(this.amount);
    }

    public int getMaxEnergyStored() {
        return Math.toIntExact(this.capacity);
    }

    @Override
    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public void charge(SwitchedWire wire) {
        float wattToFE = IFEBridgeHandler.wattToFE();
        if (wire.getState()) {
            float I = wire.current();
            this.amount += Math.round((double)(I * I) * wire.getResistance() * (double)wattToFE);
            this.be.m_6596_();
        }
    }

    @Override
    public long moveEnergy() {
        if (this.amount > 0L) {
            Direction facing = (Direction)this.be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            BlockEntity neighbour = this.be.m_58904_().m_7702_(this.be.m_58899_().m_121945_(facing));
            if (neighbour == null) {
                return 0L;
            }
            long[] amounts = new long[1];
            neighbour.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).ifPresent(handler -> {
                int received = handler.receiveEnergy((int)this.amount, false);
                this.extractEnergy(received, false);
                amounts[0] = received;
            });
            return amounts[0];
        }
        return 0L;
    }

    @Override
    public void manageWire(SwitchedWire wire) {
        long maxCharge;
        float V = Math.abs(wire.potentialDifference());
        this.capacity = maxCharge = (long)(V * IFEBridgeHandler.voltToFE());
        long missingCharge = maxCharge - this.amount;
        if (missingCharge <= 0L) {
            wire.setState(false);
            return;
        }
        float targetWatts = (float)missingCharge / IFEBridgeHandler.wattToFE();
        float resistance = V * V / targetWatts;
        if (resistance > 0.0f) {
            wire.setResistance(resistance);
            wire.setState(true);
        } else {
            wire.setState(false);
        }
    }
}

