/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electricswitch;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.config.ResistanceValues;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.electricswitch.HvSwitchBlockEntity;
import org.patryk3211.powergrid.electricity.info.Current;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Resistance;

public class HvSwitchBlock
extends HorizontalKineticBlock
implements IElectric,
IBE<HvSwitchBlockEntity>,
IHaveElectricProperties {
    public static final IntegerProperty PART = IntegerProperty.m_61631_((String)"part", (int)0, (int)1);
    private static final VoxelShape SHAPE_0 = Shapes.m_83124_((VoxelShape)HvSwitchBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{HvSwitchBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0), HvSwitchBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape SHAPE_1 = Shapes.m_83110_((VoxelShape)HvSwitchBlock.m_49796_((double)4.0, (double)0.0, (double)9.0, (double)12.0, (double)5.0, (double)15.0), (VoxelShape)HvSwitchBlock.m_49796_((double)4.0, (double)5.0, (double)10.0, (double)12.0, (double)12.0, (double)14.0));
    private static final TerminalBoundingBox TERMINAL_0 = new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 6.0, 12.0, 0.0, 10.0, 16.0, 4.0);
    private static final TerminalBoundingBox TERMINAL_1 = new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 6.0, 0.0, 15.0, 10.0, 4.0, 16.0);
    private BlockStateTerminalCollection terminals = null;
    private ImmutableMap<BlockState, VoxelShape> outlines = null;

    public HvSwitchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        VoxelShaper[] shapers = new VoxelShaper[]{VoxelShaper.forHorizontal((VoxelShape)SHAPE_0, (Direction)Direction.SOUTH), VoxelShaper.forHorizontal((VoxelShape)SHAPE_1, (Direction)Direction.SOUTH)};
        this.setTerminalCollection(BlockStateTerminalCollection.builder((Block)this).forAllStatesExcept(state -> {
            TerminalBoundingBox[] terminalBoundingBoxArray;
            Integer part = (Integer)state.m_61143_((Property)PART);
            TerminalBoundingBox terminal = part == 0 ? TERMINAL_0 : TERMINAL_1;
            Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
            terminal = terminal.rotateAroundY((int)facing.m_122435_());
            if (part == 0) {
                TerminalBoundingBox[] terminalBoundingBoxArray2 = new TerminalBoundingBox[2];
                terminalBoundingBoxArray2[0] = terminal;
                terminalBoundingBoxArray = terminalBoundingBoxArray2;
                terminalBoundingBoxArray2[1] = null;
            } else {
                TerminalBoundingBox[] terminalBoundingBoxArray3 = new TerminalBoundingBox[2];
                terminalBoundingBoxArray3[0] = null;
                terminalBoundingBoxArray = terminalBoundingBoxArray3;
                terminalBoundingBoxArray3[1] = terminal;
            }
            return terminalBoundingBoxArray;
        }, new Property[0]).withShapeMapper(state -> {
            Integer part = (Integer)state.m_61143_((Property)PART);
            Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
            return shapers[part].get(facing);
        }).build());
    }

    protected void setTerminalCollection(BlockStateTerminalCollection terminals) {
        this.terminals = terminals;
        Function<BlockState, VoxelShape> mapper = terminals.shapeMapper();
        if (mapper != null) {
            this.outlines = this.m_152458_(mapper);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.outlines != null) {
            return (VoxelShape)this.outlines.get((Object)state);
        }
        return super.m_5940_(state, world, pos, context);
    }

    @Override
    public ITerminalPlacement terminal(BlockState state, int index) {
        if (this.terminals != null) {
            return this.terminals.get(state, index);
        }
        return null;
    }

    @Override
    public int terminalCount() {
        if (this.terminals != null) {
            return this.terminals.count();
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PART});
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        BlockState neighbor = world.m_8055_(pos.m_121945_(facing));
        return neighbor.m_247087_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredHorizontalFacing(context);
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            preferred = null;
        }
        Direction facing = context.m_8125_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PART, (Comparable)Integer.valueOf(0))).m_61124_(HORIZONTAL_FACING, (Comparable)(preferred != null ? preferred.m_122427_() : facing));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (world.f_46443_ || (Integer)state.m_61143_((Property)PART) != 0) {
            return;
        }
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        world.m_46597_(pos.m_121945_(facing), (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(1)));
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        boolean drop;
        super.m_5707_(world, pos, state, player);
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        boolean bl = drop = player == null || !player.m_7500_();
        if ((Integer)state.m_61143_((Property)PART) == 0) {
            world.m_46961_(pos.m_121945_(facing), drop);
        } else {
            world.m_46961_(pos.m_121945_(facing.m_122424_()), drop);
        }
    }

    @Override
    public ElectricBehaviour getBehaviour(Level world, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)PART) == 0) {
            return IElectric.super.getBehaviour(world, pos, state);
        }
        return IElectric.super.getBehaviour(world, pos.m_121945_(((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122424_()), state);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122427_().m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if ((Integer)state.m_61143_((Property)PART) == 1) {
            return false;
        }
        return this.getRotationAxis(state) == face.m_122434_();
    }

    public Class<HvSwitchBlockEntity> getBlockEntityClass() {
        return HvSwitchBlockEntity.class;
    }

    public BlockEntityType<? extends HvSwitchBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.HV_SWITCH.get();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)PART) == 0) {
            return super.m_142194_(pos, state);
        }
        return null;
    }

    @Override
    public boolean accepts(ItemStack wireStack) {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.FAIL;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level;
        InteractionResult result = super.onSneakWrenched(state, context);
        if (result == InteractionResult.SUCCESS && (level = context.m_43725_()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            BlockPos pos = context.m_8083_();
            Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
            Level world = context.m_43725_();
            if ((Integer)state.m_61143_((Property)PART) == 0) {
                world.m_46961_(pos.m_121945_(facing), false);
            } else {
                BlockPos pos2 = pos.m_121945_(facing.m_122424_());
                Player player = context.m_43723_();
                if (player != null && !player.m_7500_()) {
                    Block.m_49874_((BlockState)state, (ServerLevel)serverWorld, (BlockPos)pos2, (BlockEntity)world.m_7702_(pos2), (Entity)player, (ItemStack)context.m_43722_()).forEach(stack -> player.m_150109_().m_150079_(stack));
                }
                state.m_222967_(serverWorld, pos2, ItemStack.f_41583_, true);
                world.m_46961_(pos2, false);
            }
        }
        return result;
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Resistance.series(ResistanceValues.get((Block)this), player, tooltip);
        Current.max(stack, player, tooltip);
    }
}

