/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electromagnet;

import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.deviceconnector.IAcceptConnector;
import org.patryk3211.powergrid.electricity.electromagnet.ElectromagnetBlockEntity;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Power;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.info.Voltage;

public class ElectromagnetBlock
extends ElectricBlock
implements IBE<ElectromagnetBlockEntity>,
IHaveElectricProperties,
IAcceptConnector {
    private static final VoxelShape DOWN_SHAPE = Shapes.m_83110_((VoxelShape)ElectromagnetBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)ElectromagnetBlock.m_49796_((double)3.5, (double)-6.0, (double)3.5, (double)12.5, (double)1.0, (double)12.5));

    public ElectromagnetBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return DOWN_SHAPE;
    }

    public Class<ElectromagnetBlockEntity> getBlockEntityClass() {
        return ElectromagnetBlockEntity.class;
    }

    public BlockEntityType<? extends ElectromagnetBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.ELECTROMAGNET.get();
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Resistance.series(this.resistance(), player, tooltip);
        float minCurrent = 2.5f;
        Voltage.min(minCurrent * this.resistance(), player, tooltip);
        Power.max(stack, player, tooltip);
    }

    @Override
    public boolean canConnect(LevelReader world, BlockPos pos, BlockState state, Direction side) {
        return side != Direction.DOWN;
    }
}

