/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electromagnet;

import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.electromagnet.BeltMagnetizingCallbacks;
import org.patryk3211.powergrid.electricity.electromagnet.MagnetizationParticleData;

public class MagnetizingBehaviour
extends BeltProcessingBehaviour {
    public static final int CYCLE = 240;
    public static final int COLLAPSE_TIME = 220;
    public static final int ENTITY_SCAN = 10;
    public final MagnetizingBehaviourSpecifics specifics;
    public Mode mode;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    private int entityScanCooldown;
    public Vec3 target;

    public <T extends SmartBlockEntity> MagnetizingBehaviour(T be) {
        super(be);
        this.specifics = (MagnetizingBehaviourSpecifics)be;
        this.whenItemEnters((s, i) -> BeltMagnetizingCallbacks.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> BeltMagnetizingCallbacks.whenItemHeld(s, i, this));
        this.mode = Mode.WORLD;
    }

    public void start(Mode mode, Vec3 target) {
        this.mode = mode;
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.target = target;
        this.blockEntity.sendData();
    }

    public void updateTarget(Vec3 target) {
        this.target = target;
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.running = compound.m_128471_("Running");
        this.mode = Mode.values()[compound.m_128451_("Mode")];
        this.prevRunningTicks = this.runningTicks = compound.m_128451_("Ticks");
        if (compound.m_128441_("Target")) {
            CompoundTag tag = compound.m_128469_("Target");
            this.target = new Vec3((double)tag.m_128457_("X"), (double)tag.m_128457_("Y"), (double)tag.m_128457_("Z"));
        } else {
            this.target = null;
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("Running", this.running);
        compound.m_128405_("Mode", this.mode.ordinal());
        compound.m_128405_("Ticks", this.runningTicks);
        if (this.target != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("X", (float)this.target.f_82479_);
            tag.m_128350_("Y", (float)this.target.f_82480_);
            tag.m_128350_("Z", (float)this.target.f_82481_);
            compound.m_128365_("Target", (Tag)tag);
        }
    }

    public void tick() {
        super.tick();
        Level world = this.getWorld();
        BlockPos pos = this.getPos();
        if (!this.running || world == null) {
            if (world != null && (!world.f_46443_ || this.blockEntity.isVirtual())) {
                if (this.specifics.getFieldStrength() == 0.0f) {
                    return;
                }
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos.m_6625_(2), (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    for (ItemEntity itemEntity : world.m_45976_(ItemEntity.class, new AABB(pos.m_7495_()).m_82406_(0.125))) {
                        if (!itemEntity.m_6084_() || !itemEntity.m_20096_() || !this.specifics.tryProcessInWorld(itemEntity, true)) continue;
                        this.start(Mode.WORLD, itemEntity.m_20182_().m_82520_(0.0, 0.25, 0.0));
                        return;
                    }
                }
            }
            return;
        }
        if (world.f_46443_ && this.runningTicks == -220) {
            this.prevRunningTicks = 220;
            return;
        }
        if (world.f_46443_) {
            RandomSource r = world.f_46441_;
            float particleChance = this.specifics.getFieldStrength() / 8.0f;
            if (this.runningTicks < 210 && r.m_188501_() < particleChance) {
                Vec3 pos0 = pos.m_252807_().m_231075_(Direction.DOWN, (double)1.1f);
                Vec3 pos1 = this.target != null ? this.target.m_231075_(Direction.DOWN, (double)-0.1f) : pos0.m_231075_(Direction.DOWN, 1.0);
                Vec3 particlePos = VecHelper.lerp((float)r.m_188501_(), (Vec3)pos0, (Vec3)pos1).m_82520_((double)((r.m_188501_() - 0.5f) * 0.2f), (double)((r.m_188501_() - 0.5f) * 0.2f), (double)((r.m_188501_() - 0.5f) * 0.2f));
                world.m_7106_((ParticleOptions)new MagnetizationParticleData(pos), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
        if (this.runningTicks == 220 && this.specifics.getFieldStrength() != 0.0f) {
            if (this.mode == Mode.WORLD) {
                this.applyInWorld();
            }
            if (!world.f_46443_) {
                this.blockEntity.sendData();
            }
        }
        if ((!world.f_46443_ || this.blockEntity.isVirtual()) && this.runningTicks > 240) {
            this.running = false;
            this.specifics.onMagnetizationComplete();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 220 && this.runningTicks >= 220) {
            this.runningTicks = 220;
            if (world.f_46443_ && !this.blockEntity.isVirtual()) {
                this.runningTicks = -220;
            }
        }
        if (this.prevRunningTicks < 215 && this.runningTicks >= 215) {
            ModdedSoundEvents.MAGNETIZING.playOnServer(this.getWorld(), (Vec3i)this.getPos(), 0.5f, 1.0f);
        }
        if (this.running && this.specifics.getFieldStrength() == 0.0f) {
            this.running = false;
            this.blockEntity.sendData();
        }
    }

    protected void applyInWorld() {
        Level world = this.getWorld();
        BlockPos pos = this.getPos();
        AABB bb = new AABB(pos.m_6625_(1));
        if (world.f_46443_) {
            return;
        }
        for (Entity entity : world.m_45933_(null, bb)) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.m_6084_() || !entity.m_20096_()) continue;
            this.entityScanCooldown = 0;
            if (!this.specifics.tryProcessInWorld(itemEntity, false)) break;
            this.target = itemEntity.m_20182_();
            this.blockEntity.sendData();
            break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getFieldStrength();
        if (speed == 0.0f) {
            return 0;
        }
        return Mth.m_269140_((float)Mth.m_14036_((float)(Math.abs(speed) / 32.0f), (float)0.0f, (float)1.0f), (int)1, (int)60);
    }

    public static interface MagnetizingBehaviourSpecifics {
        public boolean tryProcessOnBelt(TransportedItemStack var1, List<ItemStack> var2, boolean var3);

        public boolean tryProcessInWorld(ItemEntity var1, boolean var2);

        public void onMagnetizationComplete();

        public float getFieldStrength();
    }

    public static enum Mode {
        WORLD,
        BELT;

    }
}

