/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.fuse;

import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.fuse.FuseHolderBlock;
import org.patryk3211.powergrid.electricity.fuse.FuseState;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.utility.Lang;

public class FuseHolderBlockEntity
extends ElectricBlockEntity {
    private ScrollValueBehaviour setting;
    private SwitchedWire fuseWire;
    private FuseState state;

    public FuseHolderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = (FuseState)((Object)state.m_61143_(FuseHolderBlock.STATE));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.setting = new ScrollValueBehaviour((Component)Lang.translateDirect("devices.fuse.setting", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new BoxTransform()).withFormatter(i -> Integer.toString(Math.max(1, i))).between(1, 100);
        this.setting.value = 10;
        behaviours.add((BlockEntityBehaviour)this.setting);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.fuseWire = builder.connectSwitch(this.resistance(), builder.terminalNode(0), builder.terminalNode(1), this.state == FuseState.CLOSED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playEffect() {
        if (this.f_58857_ == null) {
            return;
        }
        Vec3 pos = this.f_58858_.m_252807_();
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FuseHolderBlock.FACING);
        SparkParticleData.explodeParticles(this.f_58857_, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, facing.m_122424_(), 5);
        ModdedSoundEvents.FUSE_POPS.playAt(this.f_58857_, pos, 1.0f, 1.0f, false);
    }

    public void tick() {
        super.tick();
        if (this.fuseWire.getState() && this.fuseWire.isConverged() && Math.abs(this.fuseWire.current()) > (float)this.setting.value) {
            this.setState(FuseState.BLOWN);
            if (this.f_58857_.f_46443_) {
                this.playEffect();
            }
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        FuseState prevState = this.state;
        this.state = FuseState.values()[tag.m_128451_("State")];
        if (clientPacket && this.state == FuseState.BLOWN && prevState == FuseState.CLOSED) {
            this.playEffect();
        }
        this.fuseWire.setState(this.state == FuseState.CLOSED);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("State", this.state.ordinal());
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128405_("State", this.state.ordinal());
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        if (this.state == FuseState.CLOSED) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, ModdedItems.IRON_WIRE.asStack());
        }
        return ItemRequirement.NONE;
    }

    public boolean resetFuse() {
        if (this.state == FuseState.OPEN || this.state == FuseState.BLOWN) {
            if (!this.f_58857_.f_46443_) {
                this.setState(FuseState.CLOSED);
                ModdedSoundEvents.FUSE_INSTALL.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
            }
            return true;
        }
        return false;
    }

    public boolean removeBlown() {
        if (this.state == FuseState.BLOWN) {
            this.setState(FuseState.OPEN);
            return true;
        }
        return false;
    }

    public void setState(FuseState state) {
        if (this.state != state) {
            this.state = state;
            if (this.f_58857_ != null) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(FuseHolderBlock.STATE, (Comparable)((Object)state)));
                if (!this.f_58857_.f_46443_) {
                    this.notifyUpdate();
                }
            }
            this.fuseWire.setState(state == FuseState.CLOSED);
        }
    }

    public static class BoxTransform
    extends CenteredSideValueBoxTransform {
        public BoxTransform() {
            super((state, dir) -> dir.m_122424_() == state.m_61143_((Property)FuseHolderBlock.FACING));
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)9.0);
        }
    }
}

