/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.gauge;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.gauge.GaugeValueBehaviour;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public abstract class GaugeBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    protected GaugeValueBehaviour gaugeValue;
    protected float maxValue;
    public float dialTarget;
    public float prevDialState;
    public float dialState;
    public int redstoneOutput;

    public GaugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (!Float.isNaN(this.dialTarget)) {
            int newOutput;
            this.prevDialState = this.dialState;
            this.dialState += (this.dialTarget - this.dialState) * 0.125f;
            if (this.dialState > 1.0f && this.f_58857_.f_46441_.m_188501_() < 0.5f) {
                this.dialState -= (this.dialState - 1.0f) * this.f_58857_.f_46441_.m_188501_();
            }
            if ((newOutput = Mth.m_14143_((float)Mth.m_14036_((float)(this.dialTarget * 15.0f), (float)0.0f, (float)15.0f))) != this.redstoneOutput) {
                this.redstoneOutput = newOutput;
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    public float getProgress() {
        return Mth.m_14036_((float)this.dialTarget, (float)0.0f, (float)1.0f);
    }

    public abstract float getValue();

    public abstract Unit getUnit();

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.builder((String)"create").translate("gui.gauge.info_header", new Object[0]).forGoggles(tooltip);
        return true;
    }

    public static class BoxTransform
    extends CenteredSideValueBoxTransform {
        public BoxTransform() {
            super((state, dir) -> dir == Direction.UP);
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)14.5);
        }
    }
}

