/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.heater;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.ThermalValues;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class HeaterBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    private ElectricWire wire;
    private State state = State.COLD;

    public HeaterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.thermalBehaviour == null) {
            PowerGrid.LOGGER.warn("Heating coil should always have a thermal behaviour");
            return;
        }
        float temperature = this.thermalBehaviour.getTemperature();
        if (temperature < 200.0f) {
            this.updateState(State.COLD);
        } else if (temperature < 400.0f) {
            this.updateState(State.SMOKING);
        } else {
            this.updateState(State.BLASTING);
        }
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        Block block = this.m_58900_().m_60734_();
        return ThermalBehaviour.always(this, ThermalValues.getMass(block), ThermalValues.getPower(block) / 600.0f, 600.0f);
    }

    private void updateState(State state) {
        assert (this.f_58857_ != null);
        if (this.state != state) {
            this.state = state;
            this.f_58857_.m_6289_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }

    protected ChatFormatting temperatureColor(float value) {
        if (value < 200.0f) {
            return ChatFormatting.DARK_GRAY;
        }
        if (value < 400.0f) {
            return ChatFormatting.GREEN;
        }
        if (value < 550.0f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate("gui.heater.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.heater.title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float temperature = this.thermalBehaviour.getTemperature();
        temperature = (float)Math.round(temperature * 100.0f) / 100.0f;
        String temperatureText = String.format("%.2f", Float.valueOf(temperature));
        Lang.builder().text(temperatureText).add(Component.m_130674_((String)" ")).add(Unit.TEMPERATURE.get()).style(this.temperatureColor(temperature)).forGoggles(tooltip, 1);
        return true;
    }

    public static enum State {
        COLD,
        SMOKING,
        BLASTING;

    }
}

