/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.bulb;

import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedTags;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulb;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulbState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlockEntity;

public class GrowthLamp
extends LightBulb {
    public GrowthLamp(Item.Properties settings) {
        super(settings);
    }

    @Override
    public LightBulbState createState(LightFixtureBlockEntity fixture) {
        return new State(this, fixture, this.modelSupplier);
    }

    public static class State
    extends LightBulb.SimpleState {
        public <T extends Item> State(T bulb, LightFixtureBlockEntity fixture, Supplier<Function<LightBulb.State, PartialModel>> modelProviderSupplier) {
            super(bulb, fixture, modelProviderSupplier);
        }

        @Override
        public void tick() {
            int z;
            int y;
            int x;
            BlockPos pos;
            BlockState state;
            super.tick();
            if (this.burned) {
                return;
            }
            Level world = this.fixture.m_58904_();
            int power = this.getPowerLevel();
            if (world.f_46443_ || power == 0) {
                return;
            }
            BlockPos origin = this.fixture.m_58899_();
            Direction facing = ((Direction)this.fixture.m_58900_().m_61143_((Property)LightFixtureBlock.FACING)).m_122424_();
            Integer radius = (Integer)ModdedConfigs.server().electricity.growthLampRadius.get();
            int xMin = -radius.intValue();
            int xMax = radius;
            int yMin = -radius.intValue();
            int yMax = radius;
            int zMin = -radius.intValue();
            int zMax = radius;
            switch (facing) {
                case EAST: {
                    xMin = 0;
                    break;
                }
                case WEST: {
                    xMax = 0;
                    break;
                }
                case UP: {
                    yMin = 0;
                    break;
                }
                case DOWN: {
                    yMax = 0;
                    break;
                }
                case SOUTH: {
                    zMin = 0;
                    break;
                }
                case NORTH: {
                    zMax = 0;
                }
            }
            ServerLevel serverWorld = (ServerLevel)world;
            RandomSource random = serverWorld.f_46441_;
            int chanceValue = (Integer)ModdedConfigs.server().electricity.growthLampChance.get() / power;
            if ((chanceValue <= 0 || random.m_188503_(chanceValue) == 0) && (state = serverWorld.m_8055_(pos = origin.m_7918_(x = random.m_216332_(xMin, xMax), y = random.m_216332_(yMin, yMax), z = random.m_216332_(zMin, zMax)))).m_204336_(ModdedTags.Block.AFFECTED_BY_LAMP.tag)) {
                state.m_222972_(serverWorld, pos, random);
            }
        }
    }
}

