/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.patryk3211.powergrid.collections.ModdedRenderLayers;
import org.patryk3211.powergrid.electricity.particles.ZapParticleData;

public class ZapParticle
extends Particle {
    private final Vector3f delta;
    private final Vector3f cross1;
    private final Vector3f cross2;
    private final boolean anchorEnd;
    private final int segmentCount;
    private final List<Tuple<Vector3f, Vector3f>> segments = new ArrayList<Tuple<Vector3f, Vector3f>>();

    public ZapParticle(ZapParticleData data, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        Vector3f end = data.getEnd();
        this.anchorEnd = data.isAnchored();
        this.f_107225_ = data.getLife();
        this.segmentCount = data.getSegmentCount();
        this.f_107229_ = 0.5f;
        this.delta = new Vector3f((float)((double)end.x - this.f_107212_), (float)((double)end.y - this.f_107213_), (float)((double)end.z - this.f_107214_));
        Vector3f vec = new Vector3f(1.0f - this.delta.x, 1.0f - this.delta.y, 1.0f - this.delta.z);
        this.cross1 = new Vector3f();
        vec.cross((Vector3fc)this.delta, this.cross1).normalize().mul(0.02f);
        this.cross2 = new Vector3f();
        this.cross1.cross((Vector3fc)this.delta, this.cross2).normalize().mul(0.02f);
        this.makeNewSegments();
    }

    public void addSegment(Vector3f pos1, Vector3f pos2) {
        this.segments.add((Tuple<Vector3f, Vector3f>)new Tuple((Object)pos1, (Object)pos2));
    }

    public void addSegment(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.segments.add((Tuple<Vector3f, Vector3f>)new Tuple((Object)new Vector3f(x1, y1, z1), (Object)new Vector3f(x2, y2, z2)));
    }

    public void makeNewSegments() {
        this.segments.clear();
        Vector3f pos = new Vector3f((float)this.f_107212_, (float)this.f_107213_, (float)this.f_107214_);
        Vector3f straightPos = new Vector3f((Vector3fc)pos);
        int segmentCount = this.segmentCount == -1 ? Math.max((int)(this.delta.length() / 0.5f), 3) : this.segmentCount;
        Vector3f segmentVector = new Vector3f((Vector3fc)this.delta).mul(1.0f / (float)segmentCount);
        float segmentLength = this.delta.length() / (float)segmentCount;
        float totalLength = this.delta.length();
        for (int i = 0; i < segmentCount; ++i) {
            Vector3f straightEndPos = new Vector3f((Vector3fc)segmentVector).add((Vector3fc)straightPos);
            Vector3f endPos = new Vector3f((Vector3fc)segmentVector).add((Vector3fc)pos);
            endPos.add((Vector3fc)new Vector3f((Vector3fc)this.cross1).mul(this.f_107223_.m_188501_() - 0.5f).mul(totalLength * 50.0f)).add((Vector3fc)new Vector3f((Vector3fc)this.cross2).mul(this.f_107223_.m_188501_() - 0.5f).mul(totalLength * 50.0f));
            int middle = segmentCount / 2;
            float factor = this.anchorEnd ? 1.0f - (float)Math.abs(middle - i - 1) / (float)(middle + 1) : (float)i / (float)middle;
            float invFactor = 1.0f - factor;
            endPos.mul(factor).add(straightEndPos.x * invFactor, straightEndPos.y * invFactor, straightEndPos.z * invFactor);
            this.addSegment(pos, endPos);
            if (i != 0 && this.f_107223_.m_188501_() < 0.2f) {
                float x = (this.f_107223_.m_188501_() - 0.5f) * segmentLength * 2.0f;
                float y = (this.f_107223_.m_188501_() - 0.5f) * segmentLength * 2.0f;
                float z = (this.f_107223_.m_188501_() - 0.5f) * segmentLength * 2.0f;
                this.addSegment(pos.x, pos.y, pos.z, pos.x + x, pos.y + y, pos.z + z);
                if (this.f_107223_.m_188501_() < 0.2f) {
                    float x2 = x + (this.f_107223_.m_188501_() - 0.5f);
                    float y2 = y + (this.f_107223_.m_188501_() - 0.5f);
                    float z2 = z + (this.f_107223_.m_188501_() - 0.5f);
                    this.addSegment(pos.x + x, pos.y + y, pos.z + z, pos.x + x2, pos.y + y2, pos.z + z2);
                }
            }
            straightPos = straightEndPos;
            pos = endPos;
        }
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.makeNewSegments();
        }
    }

    public void renderSegment(VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, Vector3f cross1, Vector3f cross2) {
        buffer.m_5483_((double)(x1 + cross1.x), (double)(y1 + cross1.y), (double)(z1 + cross1.z)).m_5752_();
        buffer.m_5483_((double)(x1 - cross1.x), (double)(y1 - cross1.y), (double)(z1 - cross1.z)).m_5752_();
        buffer.m_5483_((double)(x2 - cross1.x), (double)(y2 - cross1.y), (double)(z2 - cross1.z)).m_5752_();
        buffer.m_5483_((double)(x2 + cross1.x), (double)(y2 + cross1.y), (double)(z2 + cross1.z)).m_5752_();
        buffer.m_5483_((double)(x1 + cross2.x), (double)(y1 + cross2.y), (double)(z1 + cross2.z)).m_5752_();
        buffer.m_5483_((double)(x1 - cross2.x), (double)(y1 - cross2.y), (double)(z1 - cross2.z)).m_5752_();
        buffer.m_5483_((double)(x2 - cross2.x), (double)(y2 - cross2.y), (double)(z2 - cross2.z)).m_5752_();
        buffer.m_5483_((double)(x2 + cross2.x), (double)(y2 + cross2.y), (double)(z2 + cross2.z)).m_5752_();
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        DefaultSuperRenderTypeBuffer bufferProvider = DefaultSuperRenderTypeBuffer.getInstance();
        VertexConsumer buffer = bufferProvider.m_6299_(ModdedRenderLayers.getColor());
        Vec3 camPos = camera.m_90583_();
        buffer.m_7404_((int)(this.f_107227_ * 255.0f), (int)(this.f_107228_ * 255.0f), (int)(this.f_107229_ * 255.0f), (int)(this.f_107230_ * 255.0f));
        for (Tuple<Vector3f, Vector3f> segment : this.segments) {
            Vector3f pos1 = new Vector3f((Vector3fc)segment.m_14418_()).sub((Vector3fc)camPos.m_252839_());
            Vector3f pos2 = new Vector3f((Vector3fc)segment.m_14419_()).sub((Vector3fc)camPos.m_252839_());
            this.renderSegment(buffer, pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z, this.cross1, this.cross2);
        }
        buffer.m_141991_();
        bufferProvider.draw();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }
}

