/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim;

import java.util.Collection;
import java.util.List;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.solver.IAdmittanceAdder;

public abstract class AbstractElectricWire {
    protected IElectricNode node1;
    protected IElectricNode node2;
    protected ElectricalNetwork network;

    public AbstractElectricWire(IElectricNode node1, IElectricNode node2) {
        this.node1 = node1;
        this.node2 = node2;
    }

    public void setNetwork(ElectricalNetwork network) {
        this.network = network;
    }

    public ElectricalNetwork getNetwork() {
        return this.network;
    }

    public void remove() {
        if (this.network != null) {
            this.network.removeWire(this);
        }
    }

    public void setNode1(IElectricNode node1) {
        if (this.network != null) {
            ElectricalNetwork network = this.network;
            network.removeWire(this);
            this.node1 = node1;
            network.addWire(this);
        } else {
            this.node1 = node1;
        }
    }

    public void setNode2(IElectricNode node2) {
        if (this.network != null) {
            ElectricalNetwork network = this.network;
            network.removeWire(this);
            this.node2 = node2;
            network.addWire(this);
        } else {
            this.node2 = node2;
        }
    }

    public void flipNodes() {
        IElectricNode b = this.node2;
        this.node2 = this.node1;
        this.node1 = b;
    }

    public IElectricNode getNode1() {
        return this.node1;
    }

    public IElectricNode getNode2() {
        return this.node2;
    }

    public float potentialDifference() {
        if (this.node1 == null) {
            return -this.node2.getVoltage();
        }
        if (this.node2 == null) {
            return this.node1.getVoltage();
        }
        return this.node1.getVoltage() - this.node2.getVoltage();
    }

    public float current() {
        if (this.network == null) {
            return 0.0f;
        }
        return (float)((double)this.potentialDifference() * this.conductance());
    }

    public float power() {
        return this.current() * this.potentialDifference();
    }

    public abstract double conductance();

    public void stamp(IAdmittanceAdder admittance, double change) {
        if (this.node1 != null && this.node2 != null) {
            int index1 = this.node1.getIndex();
            int index2 = this.node2.getIndex();
            admittance.add(index1, index1, change);
            admittance.add(index2, index2, change);
            admittance.add(index1, index2, -change);
            admittance.add(index2, index1, -change);
        } else {
            int index = this.node1 != null ? this.node1.getIndex() : this.node2.getIndex();
            admittance.add(index, index, change);
        }
    }

    public Collection<IElectricNode> coupledNodes() {
        if (this.node1 == null) {
            return List.of(this.node2);
        }
        if (this.node2 == null) {
            return List.of(this.node1);
        }
        return List.of(this.node1, this.node2);
    }

    public List<INode> affectedNodes() {
        if (this.node1 == null) {
            return List.of(this.node2);
        }
        if (this.node2 == null) {
            return List.of(this.node1);
        }
        return List.of(this.node1, this.node2);
    }

    public boolean isConverged() {
        if (this.network == null) {
            return false;
        }
        return this.network.isConverged();
    }
}

